<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

require_once 'db.php';
require_once 'auth.php';

// محاولة توثيق المستخدم، إذا لم يكن هناك توكن نعتبره زائر
$userId = null;
$authHeader = function_exists('getallheaders') ? getallheaders() : [];
$hasToken = false;

foreach ($authHeader as $keyName => $value) {
    if (strtolower($keyName) === 'authorization') {
        $hasToken = true;
        break;
    }
}

if ($hasToken) {
    // فقط إذا كان هناك توكن نحاول التحقق منه
    $userId = authenticate();
}

// التحقق من وجود product_id في request
if (!isset($_GET['product_id'])) {
    echo json_encode([
        "status" => "error",
        "message" => "Product ID is required"
    ]);
    exit;
}

$productId = intval($_GET['product_id']); // تحويل الرقم للتأكد من صحته

// إعداد الاستعلام لجلب كل بيانات المنتج مع اسم المستخدم
$sql = "SELECT 
    p.id, p.user_id, p.category, p.name, p.price, p.phone, p.image_url, p.companies, p.processors, p.ram, p.ram_type,
    p.storage, p.storage_type, p.os, p.screen_size, p.screen_resolution, p.gpu, p.cpu_generation, p.cpu_speed,
    p.cpu_cores, p.front_camera, p.back_camera, p.network_support, p.type, p.features, p.connectivity, p.battery,
    p.weight, p.dimensions, p.governorate, p.created_at, p.details,
    u.username
FROM user_guest_products p
LEFT JOIN users u ON p.user_id = u.id
WHERE p.id = ?
LIMIT 1";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $productId);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    echo json_encode([
        "status" => "success",
        "product" => $row,
        "user_id" => $userId // يمكن أن يكون null للزائر
    ]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Product not found"
    ]);
}

$stmt->close();
$conn->close();
