<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

require_once 'db.php';

$page = isset($_GET['page']) ? (int)$_GET['page'] : 0;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 20;

$offset = $page * $limit;

$sql = "SELECT p.id, p.user_id, p.category, p.name, p.ram, p.storage, p.price, p.image_url, 
               p.governorate, p.is_active,
               SUBSTRING_INDEX(u.username, ' ', 1) AS owner_name, 
               p.phone AS owner_phone
        FROM user_guest_products p
        INNER JOIN users u ON p.user_id = u.id
        ORDER BY p.created_at DESC
        LIMIT ? OFFSET ?";

$stmt = $conn->prepare($sql);
if (!$stmt) {
    echo json_encode([
        "status" => "error",
        "message" => "فشل في تحضير الاستعلام: " . $conn->error
    ]);
    exit;
}

$stmt->bind_param("ii", $limit, $offset);
$stmt->execute();

$stmt->bind_result(
    $id, $user_id, $category, $name, $ram, $storage,
    $price, $image_url, $governorate, $is_active,
    $owner_name, $owner_phone
);

$products = [];

while ($stmt->fetch()) {
    $products[] = [
        "id" => (int)$id,
        "user_id" => (int)$user_id,
        "category" => $category,
        "name" => $name,
        "ram" => $ram,
        "storage" => $storage,
        "price" => (float)$price,
        "image_url" => $image_url,
        "governorate" => $governorate,
        "is_active" => (int)$is_active,
        "owner_name" => $owner_name,
        "owner_phone" => $owner_phone,
    ];
}

$stmt->close();

echo json_encode([
    "status" => "success",
    "data" => $products
]);
?>
