<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

require_once 'db.php';
require_once 'auth.php';

// جلب user_id من التوكن
$userId = authenticate(); 

// استعلام لجلب منتجات المستخدم
$sql = "SELECT id, user_id, category, name, ram, storage, price, governorate, phone, image_url, created_at, is_active
        FROM user_guest_products 
        WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();

$products = [];

while ($row = $result->fetch_assoc()) {
    // نترك image_url كما هو مخزن في قاعدة البيانات
    $products[] = $row;
}

if (count($products) > 0) {
    echo json_encode([
        "status" => "success",
        "has_device" => true,
        "products" => $products
    ]);
} else {
    echo json_encode([
        "status" => "success",
        "has_device" => false,
        "products" => []
    ]);
}

$stmt->close();
$conn->close();
?>
