 <?php
ob_start();
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=UTF-8");
error_reporting(E_ALL);

require_once __DIR__ . '/auth.php';
require_once 'db.php';

$userId = authenticate();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status'=>'error','message'=>'Invalid request method']);
    exit;
}

$user_id = $userId;
$category = $_POST['category'] ?? null;
$name = $_POST['name'] ?? null;
$price = floatval($_POST['price'] ?? 0);
$phone = $_POST['phone'] ?? null;
$governorate = $_POST['governorate'] ?? null;
$details_text = $_POST['details'] ?? null;

/* ================== الحقول العامة الإجبـارية ================== */
if (!$category || !$name || !$price || !$phone || !$governorate) {
    echo json_encode(['status'=>'error','message'=>'يرجى تعبئة جميع الحقول الأساسية']);
    exit;
}

/* ================== حد الإعلانات ================== */
$checkStmt = $conn->prepare(
    "SELECT COUNT(*) FROM user_guest_products WHERE user_id = ?"
);
$checkStmt->bind_param("i", $user_id);
$checkStmt->execute();
$checkStmt->bind_result($productCount);
$checkStmt->fetch();
$checkStmt->close();

if ($productCount >= 2) {
    echo json_encode([
        'status'=>'error',
        'message'=>'لقد وصلت إلى الحد الأقصى من الإعلانات'
    ]);
    exit;
}

/* ================== الوصف + الصورة (إجباري لكل الفئات) ================== */
if (!$details_text) {
    echo json_encode(['status'=>'error','message'=>'وصف المنتج مطلوب']);
    exit;
}

if (!isset($_FILES['image']) || $_FILES['image']['error'] !== UPLOAD_ERR_OK) {
    echo json_encode(['status'=>'error','message'=>'صورة المنتج مطلوبة']);
    exit;
}

/* ================== تحقق حسب الفئة ================== */
$requiredByCategory = [
    'laptop' => ['companies','processors','ram','storage'],
    'mobile' => ['processors','ram','storage'],
    'technology' => ['companies'],
];

if (isset($requiredByCategory[$category])) {
    foreach ($requiredByCategory[$category] as $field) {
        if (empty($_POST[$field])) {
            echo json_encode([
                'status'=>'error',
                'message'=>"الحقل {$field} مطلوب"
            ]);
            exit;
        }
    }
}

/* ================== رفع الصورة ================== */
$image = $_FILES['image'];
$ext = pathinfo($image['name'], PATHINFO_EXTENSION);
$filename = uniqid("user_") . '.' . $ext;
$targetDir = "storePicUploads/user_products/";
if (!is_dir($targetDir)) mkdir($targetDir, 0755, true);
$targetPath = $targetDir . $filename;
move_uploaded_file($image['tmp_name'], $targetPath);
$image_url = $targetPath;




/* الحقول الإضافية حسب الفئة */
$laptop_fields = [
    'companies','processors','ram','ram_type','storage','storage_type',
    'gpu','os','screen_size','screen_resolution','cpu_generation',
    'cpu_speed','cpu_cores','battery','weight','dimensions'
];

$mobile_fields = [
    'companies','processors','ram','ram_type','storage','storage_type',
    'os','screen_size','screen_resolution','front_camera','back_camera',
    'battery','network_support','weight','dimensions'
];

$technology_fields = [
    'companies','type','features','battery','weight','dimensions','connectivity'
];

switch ($category) {
    case 'laptop':
        $all_fields = $laptop_fields;
        break;

    case 'mobile':
        $all_fields = $mobile_fields;
        break;

    case 'technology':
        $all_fields = $technology_fields;
        break;

    default:
        echo json_encode([
            'status' => 'error',
            'message' => 'فئة غير مدعومة'
        ]);
        exit;
}

/* جمع القيم الإضافية */
$values = [];
foreach ($all_fields as $field) {
    $values[$field] = $_POST[$field] ?? null;
}

/* إنشاء statement ديناميكي */
$columns = implode(",", $all_fields);
$placeholders = implode(",", array_fill(0, count($all_fields), '?'));

$sql = "
INSERT INTO user_guest_products 
(
    user_id, category, name, price, phone, image_url,
    governorate, details, $columns, created_at
)
VALUES
(
    ?, ?, ?, ?, ?, ?, ?, ?, $placeholders, NOW()
)
";

$stmt = $conn->prepare($sql);

if (!$stmt) {
    echo json_encode([
        'status' => 'error',
        'message' => 'فشل في إعداد الاستعلام: ' . $conn->error
    ]);
    exit;
}

/* إعداد الأنواع للـ bind_param */
$types = 'issdssss' . str_repeat('s', count($all_fields));

$params = array_merge(
    [$types, $user_id, $category, $name, $price, $phone, $image_url, $governorate, $details_text],
    array_values($values)
);

/* bind_param ديناميكي */
$tmp = [];
foreach ($params as $key => $value) {
    $tmp[$key] = &$params[$key];
}

call_user_func_array([$stmt, 'bind_param'], $tmp);

if ($stmt->execute()) {
    echo json_encode([
        'status' => 'success',
        'message' => 'تم نشر المنتج بنجاح'
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'فشل في إضافة المنتج: ' . $stmt->error
    ]);
}
?>
