<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

require_once __DIR__ . '/auth.php';

$userId = authenticate();

$maxFileSize = 5 * 1024 * 1024; // 5MB

// تأكد من إرسال الصورة
if (!isset($_FILES['image'])) {
    echo json_encode(['status' => 'error', 'message' => 'لم يتم إرسال أي صورة']);
    exit;
}

// فحص حجم الصورة
if ($_FILES['image']['size'] > $maxFileSize) {
    echo json_encode(['status' => 'error', 'message' => 'حجم الصورة كبير جدًا. الحد الأقصى هو 5MB']);
    exit;
}

// تأكد من إرسال store_id
if (!isset($_POST['store_id']) || empty($_POST['store_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'يجب إرسال معرف المتجر store_id']);
    exit;
}

$storeId = intval($_POST['store_id']);

// التحقق من ملكية المتجر
require_once 'db.php';
$ownershipQuery = "SELECT id FROM stores WHERE id = ? AND user_id = ?";
$stmtOwnership = $conn->prepare($ownershipQuery);
$stmtOwnership->bind_param("ii", $storeId, $userId);
$stmtOwnership->execute();
$stmtOwnership->bind_result($verifiedStoreId);
$hasOwnership = $stmtOwnership->fetch();
$stmtOwnership->close();

if (!$hasOwnership) {
    echo json_encode(['status' => 'error', 'message' => 'المتجر غير موجود أو ليس لديك صلاحية لرفع الصور إليه']);
    exit;
}

$uploadDir = __DIR__ . "/storePicUploads/";

// إنشاء مجلد باسم المتجر
$storeDir = $uploadDir . $storeId . "/";
if (!is_dir($storeDir)) {
    if (!mkdir($storeDir, 0777, true)) {
        echo json_encode(['status' => 'error', 'message' => 'تعذر إنشاء مجلد المتجر']);
        exit;
    }
}

// تجهيز مسار الصورة
$imageTmpPath = $_FILES['image']['tmp_name'];
$originalName = basename($_FILES['image']['name']);
$ext = pathinfo($originalName, PATHINFO_EXTENSION);
$newName = uniqid("img_", true) . "." . strtolower($ext);
$targetPath = $storeDir . $newName;

// نقل الملف
if (move_uploaded_file($imageTmpPath, $targetPath)) {
    echo json_encode([
        'status' => 'success',
        'filename' => $storeId . '/' . $newName,
        'message' => 'تم رفع الصورة بنجاح'
    ]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'فشل رفع الصورة']);
}
?>
