<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

require_once __DIR__ . '/auth.php';
include 'db.php';

$userId = authenticate();

$data = json_decode(file_get_contents("php://input"));

$user_id = $userId;

// تحديث الدور إلى vendor
$query = "UPDATE users SET role = 'vendor' WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "تم تحديث الدور إلى بائع (vendor)"]);
} else {
    echo json_encode(["status" => "error", "message" => "فشل تحديث الدور."]);
}
?>
