<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

require_once __DIR__ . '/auth.php';
include 'db.php';

$userId = authenticate();

// تحقق من نوع الطلب
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        "status" => "error",
        "message" => "طريقة الطلب غير مدعومة"
    ]);
    exit;
}

// تأكد أن جميع الحقول الأساسية موجودة
if (
    empty($_POST["id"]) ||
    empty($_POST["name"]) ||
    empty($_POST["description"]) ||
    empty($_POST["phone"]) ||
    empty($_POST["governorate"]) ||
    empty($_POST["location"])
) {
    echo json_encode([
        "status" => "error",
        "message" => "الرجاء ملء جميع الحقول"
    ]);
    exit;
}

$id = intval($_POST["id"]);

// التحقق من ملكية المتجر
$ownershipQuery = "SELECT image FROM stores WHERE id = ? AND user_id = ?";
$stmtOwnership = $conn->prepare($ownershipQuery);
$stmtOwnership->bind_param("ii", $id, $userId);
$stmtOwnership->execute();
$stmtOwnership->bind_result($oldImageName);
$hasOwnership = $stmtOwnership->fetch();
$stmtOwnership->close();

if (!$hasOwnership) {
    echo json_encode([
        "status" => "error",
        "message" => "المتجر غير موجود أو ليس لديك صلاحية لتحديثه"
    ]);
    exit;
}

$name = htmlspecialchars(strip_tags($_POST["name"]));
$description = htmlspecialchars(strip_tags($_POST["description"]));
$phone = htmlspecialchars(strip_tags($_POST["phone"]));
$governorate = htmlspecialchars(strip_tags($_POST["governorate"]));
$location = htmlspecialchars(strip_tags($_POST["location"]));
$imageName = null;

$uploadDir = "storePicUploads/";

// إذا تم رفع صورة جديدة
if (isset($_FILES["image"]) && $_FILES["image"]["error"] === UPLOAD_ERR_OK) {

    if ($_FILES["image"]["size"] > 250 * 1024) {
        echo json_encode([
            "status" => "error",
            "message" => "يجب ألا يتجاوز حجم الصورة 250 كيلوبايت"
        ]);
        exit;
    }

    // تأكد أن الملف فعلا صورة
    $check = getimagesize($_FILES["image"]["tmp_name"]);
    if ($check === false) {
        echo json_encode([
            "status" => "error",
            "message" => "الملف المرفوع ليس صورة صالحة"
        ]);
        exit;
    }

    // تأكد من وجود مجلد الرفع
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    // توليد اسم فريد للصورة
    $fileExt = strtolower(pathinfo($_FILES["image"]["name"], PATHINFO_EXTENSION));
    $imageName = uniqid("store_", true) . "." . $fileExt;
    $targetFile = $uploadDir . $imageName;

    if (move_uploaded_file($_FILES["image"]["tmp_name"], $targetFile)) {
        // حذف الصورة القديمة إن وجدت
        if (!empty($oldImageName)) {
            $oldFilePath = $uploadDir . $oldImageName;
            if (file_exists($oldFilePath)) {
                unlink($oldFilePath);
            }
        }
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "فشل في رفع الصورة"
        ]);
        exit;
    }
}

// تحديث البيانات مع أو بدون صورة
if ($imageName) {
    $query = "UPDATE stores 
              SET name = ?, description = ?, phone = ?, governorate = ?, location = ?, image = ?
              WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("ssssssi", $name, $description, $phone, $governorate, $location, $imageName, $id);
} else {
    $query = "UPDATE stores 
              SET name = ?, description = ?, phone = ?, governorate = ?, location = ?
              WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("sssssi", $name, $description, $phone, $governorate, $location, $id);
}

if ($stmt->execute()) {
    echo json_encode([
        "status" => "success",
        "message" => "تم تحديث المتجر بنجاح"
    ]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "فشل في تحديث المتجر"
    ]);
}

$stmt->close();
$conn->close();
?>
