<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

require_once __DIR__ . '/auth.php';
include 'db.php';

$userId = authenticate();
$data = json_decode(file_get_contents("php://input"), true);

if (empty($data['id']) || empty($data['store_id'])) {
    echo json_encode(["status"=>"error","message"=>"المعرفات مطلوبة"]);
    exit;
}

// تحقق من ملكية المنتج للمتجر
$stmt = $conn->prepare("
    SELECT p.id FROM products p
    JOIN stores s ON p.store_id=s.id
    WHERE p.id=? AND s.user_id=?
");
$stmt->bind_param("ii", $data['id'], $userId);
$stmt->execute();
if (!$stmt->get_result()->fetch_assoc()) {
    echo json_encode(["status"=>"error","message"=>"غير مصرح"]);
    exit;
}
$stmt->close();

// قائمة الحقول المسموح تحديثها
$allowedFields = [
    'store_id','name','category','description','image_url','company','model',
    'processor','ram','storage','gpu','battery','price','os','screen_size',
    'screen_resolution','front_camera','back_camera','cpu_generation','cpu_speed',
    'cpu_cores','ram_type','storage_type','network_support','weight','dimensions'
];

$set = [];
$params = [];
$types = "";

foreach ($allowedFields as $field) {
    if (isset($data[$field])) {
        $set[] = "$field=?";
        $params[] = is_string($data[$field]) ? htmlspecialchars(strip_tags($data[$field])) : $data[$field];
        if (in_array($field, ['price'])) {
            $types .= "d";
        }elseif ($field === 'store_id') {
         $types .= "i";
       } elseif ($field === 'cpu_cores') {
         $types .= "s";
         }
        else {
            $types .= "s";
        }
    }
}

if (empty($set)) {
    echo json_encode(["status"=>"error","message"=>"لا يوجد حقول للتحديث"]);
    exit;
}

$params[] = $data['id'];
$types .= "i";

$sql = "UPDATE products SET " . implode(",", $set) . " WHERE id=?";
$stmt = $conn->prepare($sql);
$stmt->bind_param($types, ...$params);

if ($stmt->execute()) {
    echo json_encode(["status"=>"success","message"=>"تم التحديث بنجاح"]);
} else {
    echo json_encode(["status"=>"error","message"=>"فشل التحديث: ".$stmt->error]);
}
$stmt->close();
?>
