<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

require_once("db.php"); // الاتصال بقاعدة البيانات

$input = json_decode(file_get_contents("php://input"), true);

if (!$input) {
    echo json_encode(["status" => "error", "message" => "بيانات غير صالحة."]);
    exit;
}

$where = [];
$params = [];
$types = "";

// شروط البحث
if (!empty($input['name'])) {
    $where[] = "p.name LIKE ?";
    $params[] = "%" . $input['name'] . "%";
    $types .= "s";
}
if (!empty($input['category'])) {
    $where[] = "p.category = ?";
    $params[] = $input['category'];
    $types .= "s";
}
if (!empty($input['company'])) {
    $where[] = "p.company = ?";
    $params[] = $input['company'];
    $types .= "s";
}
if (!empty($input['processor'])) {
    $where[] = "p.processor = ?";
    $params[] = $input['processor'];
    $types .= "s";
}
if (!empty($input['ram'])) {
    $where[] = "p.ram = ?";
    $params[] = $input['ram'];
    $types .= "s";
}
if (!empty($input['storage'])) {
    $where[] = "p.storage = ?";
    $params[] = $input['storage'];
    $types .= "s";
}
if (!empty($input['gpu'])) {
    $where[] = "p.gpu = ?";
    $params[] = $input['gpu'];
    $types .= "s";
}
if (!empty($input['battery'])) {
    $where[] = "p.battery = ?";
    $params[] = $input['battery'];
    $types .= "s";
}
// السعر الأعلى (max price)
if (!empty($input['price'])) {
    $where[] = "p.price <= ?";
    $params[] = floatval($input['price']);
    $types .= "d";
}
// السعر الأدنى (min price)
if (!empty($input['min_price'])) {
    $where[] = "p.price >= ?";
    $params[] = floatval($input['min_price']);
    $types .= "d";
}

// الاستعلام مع JOIN لبيانات المتجر
$sql = "
    SELECT 
        p.id, p.store_id, p.name, p.category, p.description, p.image_url, 
        p.company, p.model, p.processor, p.ram, p.storage, p.gpu, p.battery, 
        p.price, p.likes_count, p.updated_at,
        s.name AS store_name,
        s.phone AS store_phone,
        s.governorate AS store_governorate,
        s.location AS store_location,
        s.image AS store_image
    FROM products p
    JOIN stores s ON p.store_id = s.id
";

// إضافة شروط WHERE
if (!empty($where)) {
    $sql .= " WHERE " . implode(" AND ", $where);
}

$stmt = $conn->prepare($sql);
if (!$stmt) {
    echo json_encode([
        "status" => "error", 
        "message" => "SQL Error: " . $conn->error,
        "query_preview" => substr($sql, 0, 200)
    ]);
    exit;
}

if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$stmt->bind_result($p_id, $p_store_id, $p_name, $p_category, $p_description, $p_image_url, $p_company, $p_model, $p_processor, $p_ram, $p_storage, $p_gpu, $p_battery, $p_price, $p_likes_count, $p_updated_at, $store_name, $store_phone, $store_governorate, $store_location, $store_image);

$products = [];
// استخدام مسار نسبي بدلاً من الرابط المطلق
$basePath = "/buymo_api/storePicUploads/";

while ($stmt->fetch()) {
    // إلحاق المسار النسبي للصورة
    $storeImagePath = !empty($store_image) ? $basePath . $store_image : null;
    
    $products[] = [
        'id' => $p_id,
        'store_id' => $p_store_id,
        'name' => $p_name,
        'category' => $p_category,
        'description' => $p_description,
        'image_url' => $p_image_url,
        'company' => $p_company,
        'model' => $p_model,
        'processor' => $p_processor,
        'ram' => $p_ram,
        'storage' => $p_storage,
        'gpu' => $p_gpu,
        'battery' => $p_battery,
        'price' => $p_price,
        'likes_count' => $p_likes_count,
        'updated_at' => $p_updated_at,
        'store_name' => $store_name,
        'store_phone' => $store_phone,
        'store_governorate' => $store_governorate,
        'store_location' => $store_location,
        'store_image' => $storeImagePath
    ];
}
$stmt->close();

echo json_encode([
    "status" => "success",
    "products" => $products
]);