<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

require_once 'db.php';
require_once 'auth.php';

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->username) && !empty($data->email) && !empty($data->password) && !empty($data->phone)) {

    $username = htmlspecialchars(strip_tags($data->username));
    $email    = htmlspecialchars(strip_tags($data->email));
    $password = password_hash($data->password, PASSWORD_DEFAULT);
    $phone    = htmlspecialchars(strip_tags($data->phone));

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo json_encode(["status" => "error", "message" => "البريد الإلكتروني غير صالح."]);
        exit;
    }

    $checkEmailQuery = "SELECT id FROM users WHERE email = ?";
    $stmtEmail = $conn->prepare($checkEmailQuery);
    $stmtEmail->bind_param("s", $email);
    $stmtEmail->execute();
    $stmtEmail->store_result();

    if ($stmtEmail->num_rows > 0) {
        echo json_encode(["status" => "error", "message" => "البريد الإلكتروني مستخدم مسبقًا."]);
        exit;
    }

    $insertQuery = "INSERT INTO users (username, email, password, phone) VALUES (?, ?, ?, ?)";
    $stmtInsert = $conn->prepare($insertQuery);
    $stmtInsert->bind_param("ssss", $username, $email, $password, $phone);

    if ($stmtInsert->execute()) {
        $userId = $stmtInsert->insert_id;

        $expirySeconds = 345600;
        $tokenPayload = [
            'data' => ['user_id' => $userId],
            'exp' => time() + $expirySeconds
        ];
        $token = Firebase\JWT\JWT::encode($tokenPayload, $key, 'HS256');

        $refreshToken = bin2hex(random_bytes(32));
        $tokenExpiry = date('Y-m-d H:i:s', time() + $expirySeconds);

        $updateQuery = "UPDATE users SET token=?, refresh_token=?, token_expiry=? WHERE id=?";
        $stmtUpdate = $conn->prepare($updateQuery);
        $stmtUpdate->bind_param('sssi', $token, $refreshToken, $tokenExpiry, $userId);
        $stmtUpdate->execute();

        echo json_encode([
            "status" => "success",
            "message" => "تم التسجيل بنجاح.",
            "data" => [
                "id" => $userId,
                "username" => $username,
                "email" => $email,
                "phone" => $phone,
                "role" => "customer",
                "store_id" => null,
                "token" => $token,
                "refresh_token" => $refreshToken,
                "token_expiry" => $tokenExpiry
            ]
        ]);
    } else {
        $errorMsg = $stmtInsert->error;
        echo json_encode(["status" => "error", "message" => "خطأ في قاعدة البيانات: $errorMsg"]);
    }

} else {
    echo json_encode(["status" => "error", "message" => "الرجاء ملء جميع الحقول."]);
}
?>

