<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

require_once 'db.php';
require_once 'auth.php';

$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['user_id']) || !isset($data['refresh_token'])) {
    echo json_encode([
        "status" => "error",
        "message" => "Missing parameters"
    ]);
    exit;
}

$userId = intval($data['user_id']);
$refreshToken = $data['refresh_token'];

// تحقق من refresh token في قاعدة البيانات
$stmt = $conn->prepare("SELECT refresh_token FROM users WHERE id = ?");
$stmt->bind_param("i", $userId);
$stmt->execute();
$stmt->bind_result($dbRefreshToken);
$hasRow = $stmt->fetch();
$stmt->close();

if ($hasRow && $dbRefreshToken === $refreshToken) {

    $expirySeconds = 345600; // 1 ساعة
    $tokenPayload = [
        'data' => ['user_id' => $userId],
        'exp' => time() + $expirySeconds
    ];
    $newToken = Firebase\JWT\JWT::encode($tokenPayload, $key, 'HS256');
    $tokenExpiry = date("Y-m-d H:i:s", time() + $expirySeconds);

    $updateStmt = $conn->prepare("UPDATE users SET token=?, token_expiry=? WHERE id=?");
    $updateStmt->bind_param("ssi", $newToken, $tokenExpiry, $userId);
    $updateStmt->execute();

    echo json_encode([
        "status" => "success",
        "data" => [
            "token" => $newToken,
            "token_expiry" => $tokenExpiry
        ]
    ]);

} else {
    echo json_encode([
        "status" => "error",
        "message" => "Invalid refresh token"
    ]);
}
?>
