<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

require_once __DIR__ . '/auth.php';
include 'db.php';

$userId = authenticate();

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->product_id) && !empty($data->rating)) {
    $product_id = intval($data->product_id);
    $user_id = $userId;
    $rating = intval($data->rating);
    $comment = !empty($data->comment) ? htmlspecialchars(strip_tags($data->comment)) : "";

    if ($rating < 1 || $rating > 5) {
        echo json_encode(["status" => "error", "message" => "التقييم يجب أن يكون بين 1 و 5."]);
        exit;
    }

    $query = "INSERT INTO ratings (product_id, user_id, rating, comment) VALUES (?, ?, ?, ?)";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("iiis", $product_id, $user_id, $rating, $comment);

    if ($stmt->execute()) {
        echo json_encode(["status" => "success", "message" => "تم إضافة التقييم بنجاح."]);
    } else {
        echo json_encode(["status" => "error", "message" => "فشل في إضافة التقييم."]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "الرجاء ملء جميع الحقول المطلوبة."]);
}
?>
