<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/db.php';

$userId = authenticate();
$data = json_decode(file_get_contents("php://input"), true);

$requestId = $data['id'] ?? 0;

if ($requestId == 0) {
    echo json_encode(["success" => false, "message" => "ID غير صالح"]);
    exit;
}

$stmt = $conn->prepare("
    UPDATE market_requests
    SET is_active = 3
    WHERE id = ? AND user_id = ?
");
$stmt->bind_param("ii", $requestId, $userId);

$success = $stmt->execute();

echo json_encode([
    "success" => $success
]);
?>
