<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

require_once __DIR__ . '/auth.php';
require_once "db.php";

$userId = authenticate();

// استلام JSON من Flutter
$input = json_decode(file_get_contents("php://input"), true);
$notificationId = intval($input['notification_id'] ?? 0);

if ($notificationId <= 0) {
    echo json_encode(["status" => "error", "message" => "Invalid notification ID"]);
    exit;
}

// تحقق إذا كان هناك سجل سابق باستخدام prepared statement
$sqlCheck = "SELECT id FROM notification_reads WHERE notification_id = ? AND user_id = ?";
$stmtCheck = $conn->prepare($sqlCheck);
$stmtCheck->bind_param("ii", $notificationId, $userId);
$stmtCheck->execute();
$stmtCheck->bind_result($existingReadId);
$hasExistingRead = $stmtCheck->fetch();
$stmtCheck->close();

if ($hasExistingRead) {
    // حدث القراءة
    $sqlUpdate = "UPDATE notification_reads SET read_at = NOW() 
                  WHERE notification_id = ? AND user_id = ?";
    $stmtUpdate = $conn->prepare($sqlUpdate);
    $stmtUpdate->bind_param("ii", $notificationId, $userId);
    $stmtUpdate->execute();
    $stmtUpdate->close();
} else {
    // سجل جديد
    $sqlInsert = "INSERT INTO notification_reads (notification_id, user_id, read_at) 
                  VALUES (?, ?, NOW())";
    $stmtInsert = $conn->prepare($sqlInsert);
    $stmtInsert->bind_param("ii", $notificationId, $userId);
    $stmtInsert->execute();
    $stmtInsert->close();
}

echo json_encode(["status" => "success"]);
?>
