<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

require_once 'db.php';
require_once 'auth.php'; // يحتوي على $key و JWT class

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->email) && !empty($data->password)) {

    $email = htmlspecialchars(strip_tags($data->email));
    $password = $data->password;

    // Select role from users table (like old version)
    $query = "SELECT id, username, email, password, role FROM users WHERE email = ?";
    $stmt = $conn->prepare($query);
    
    if (!$stmt) {
        echo json_encode([
            "status" => "error",
            "message" => "خطأ في قاعدة البيانات: " . $conn->error
        ]);
        exit;
    }
    $stmt->bind_param("s", $email);
    $stmt->execute();
    
    // Bind result variables (compatible with non-mysqlnd servers)
    $stmt->bind_result($userId, $username, $userEmail, $hashedPassword, $userRole);
    
    if ($stmt->fetch()) {
        $stmt->close();
        
        // Create user array
        $user = [
            'id' => $userId,
            'username' => $username,
            'email' => $userEmail,
            'password' => $hashedPassword,
            'role' => $userRole
        ];

        if (password_verify($password, $hashedPassword)) {

            // Get store_id if user is a vendor (like old version)
            $store_id = null;
            if ($user['role'] === 'vendor') {
                $storeQuery = "SELECT id FROM stores WHERE user_id = ?";
                $storeStmt = $conn->prepare($storeQuery);
                if ($storeStmt) {
                    $storeStmt->bind_param("i", $user['id']);
                    $storeStmt->execute();
                    $storeStmt->bind_result($storeIdResult);
                    if ($storeStmt->fetch()) {
                        $store_id = $storeIdResult;
                    }
                    $storeStmt->close();
                }
            }

            // توليد JWT
            $expirySeconds = 345600; // 1 ساعة
            $tokenPayload = [
                'data' => ['user_id' => $user['id']],
                'exp' => time() + $expirySeconds
            ];
            $token = Firebase\JWT\JWT::encode($tokenPayload, $key, 'HS256');

            // توليد Refresh Token
            $refreshToken = bin2hex(random_bytes(32));
            $tokenExpiry = date('Y-m-d H:i:s', time() + $expirySeconds);

            // تحديث قاعدة البيانات
            $updateQuery = "UPDATE users SET token=?, refresh_token=?, token_expiry=? WHERE id=?";
            $updateStmt = $conn->prepare($updateQuery);
            $updateStmt->bind_param('sssi', $token, $refreshToken, $tokenExpiry, $user['id']);
            $updateStmt->execute();

            echo json_encode([
                "status" => "success",
                "message" => "تم تسجيل الدخول بنجاح.",
                "data" => [
                    "id" => $user['id'],
                    "username" => $user['username'],
                    "email" => $user['email'],
                    "role" => $user['role'],
                    "store_id" => $store_id,
                    "token" => $token,
                    "refresh_token" => $refreshToken,
                    "token_expiry" => $tokenExpiry
                ]
            ]);
            exit;

        } else {
            echo json_encode([
                "status" => "error",
                "message" => "كلمة المرور غير صحيحة."
            ]);
        }

    } else {
        echo json_encode([
            "status" => "error",
            "message" => "البريد الإلكتروني غير موجود."
        ]);
    }

} else {
    echo json_encode([
        "status" => "error",
        "message" => "الرجاء إدخال البريد الإلكتروني وكلمة المرور."
    ]);
}
?>
