<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

require_once __DIR__ . '/auth.php';
require_once("db.php");

$userId = authenticate();

$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['product_id'])) {
    echo json_encode(["status" => "error", "message" => "بيانات ناقصة"]);
    exit;
}

$productId = intval($data['product_id']);
$userId    = $userId;

// هل المنتج موجود؟ (اختياري)
$check = $conn->prepare("SELECT likes_count FROM products WHERE id = ?");
$check->bind_param("i", $productId);
$check->execute();
$check->bind_result($likesCount);
$productExists = $check->fetch();
$check->close();

if (!$productExists) {
    echo json_encode(["status" => "error", "message" => "المنتج غير موجود"]);
    exit;
}
$likesCount = intval($likesCount);

// هل المستخدم أعجب فعلاً؟
$stmt = $conn->prepare("SELECT 1 FROM product_likes WHERE product_id = ? AND user_id = ? LIMIT 1");
$stmt->bind_param("ii", $productId, $userId);
$stmt->execute();
$stmt->store_result();
$isLiked = $stmt->num_rows > 0;
$stmt->close();

echo json_encode([
    "status" => "success",
    "liked" => $isLiked,
    "likes_count" => $likesCount
]);
