<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

require_once 'db.php';
require_once 'auth.php'; // يحتوي على $key و JWT class

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->email) && !empty($data->username) && !empty($data->google_id)) {

    $email = htmlspecialchars(strip_tags($data->email));
    $username = htmlspecialchars(strip_tags($data->username));
    $google_id = htmlspecialchars(strip_tags($data->google_id));

    // تحقق إذا المستخدم موجود مسبقًا
    $stmt = $conn->prepare("SELECT id, username, email, google_id, login_provider, role FROM users WHERE google_id = ? OR email = ?");
    $stmt->bind_param("ss", $google_id, $email);
    $stmt->execute();
    $stmt->bind_result($userId, $dbUsername, $dbEmail, $dbGoogleId, $loginProvider, $dbRole);
    $hasUser = $stmt->fetch();
    $stmt->close();
    
    $user = null;
    if ($hasUser) {
        $user = [
            'id' => $userId,
            'username' => $dbUsername,
            'email' => $dbEmail,
            'google_id' => $dbGoogleId,
            'login_provider' => $loginProvider,
            'role' => $dbRole
        ];
    }

    if (!$user) {
        // إنشاء مستخدم جديد
        $stmt = $conn->prepare("INSERT INTO users (username, email, google_id, login_provider, role, created_at) VALUES (?, ?, ?, 'google', 'user', NOW())");
        $stmt->bind_param("sss", $username, $email, $google_id);
        $stmt->execute();

        $userId = $conn->insert_id;

        $stmt = $conn->prepare("SELECT id, username, email, google_id, login_provider, role FROM users WHERE id = ?");
        $stmt->bind_param("i", $userId);
        $stmt->execute();
        $stmt->bind_result($newUserId, $newUsername, $newEmail, $newGoogleId, $newLoginProvider, $newRole);
        $stmt->fetch();
        $stmt->close();
        
        $user = [
            'id' => $newUserId,
            'username' => $newUsername,
            'email' => $newEmail,
            'google_id' => $newGoogleId,
            'login_provider' => $newLoginProvider,
            'role' => $newRole
        ];
    }

    // الحصول على store_id إن وجد
    $store_id = null;
    if ($user['role'] === 'vendor') {
        $storeQuery = "SELECT id FROM stores WHERE user_id = ?";
        $storeStmt = $conn->prepare($storeQuery);
        $storeStmt->bind_param("i", $user['id']);
        $storeStmt->execute();
        $storeStmt->bind_result($storeId);
        if ($storeStmt->fetch()) {
            $store_id = $storeId;
        }
        $storeStmt->close();
    }

    // توليد JWT
    $expirySeconds = 345600; // 4 أيام
    $tokenPayload = [
        'data' => ['user_id' => $user['id']],
        'exp' => time() + $expirySeconds
    ];
    $token = Firebase\JWT\JWT::encode($tokenPayload, $key, 'HS256');

    // توليد Refresh Token
    $refreshToken = bin2hex(random_bytes(32));
    $tokenExpiry = date('Y-m-d H:i:s', time() + $expirySeconds);

    // تحديث قاعدة البيانات
    $updateQuery = "UPDATE users SET token=?, refresh_token=?, token_expiry=? WHERE id=?";
    $updateStmt = $conn->prepare($updateQuery);
    $updateStmt->bind_param('sssi', $token, $refreshToken, $tokenExpiry, $user['id']);
    $updateStmt->execute();

    // إعادة بيانات المستخدم
    echo json_encode([
        "status" => "success",
        "user" => [
            "id" => $user['id'],
            "email" => $user['email'],
            "username" => $user['username'],
            "role" => $user['role'],
            "store_id" => $store_id,
            "token" => $token,
            "refresh_token" => $refreshToken,
            "token_expiry" => $tokenExpiry
        ]
    ]);
    exit;

} else {
    echo json_encode([
        "status" => "error",
        "message" => "الرجاء إدخال البريد الإلكتروني واسم المستخدم وGoogle ID."
    ]);
}
?>
