<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

include 'db.php';
include 'gift_settings.php'; // ملف الإعدادات لكل عرض

// ✅ جلب بيانات المتجر من جدول stores مع الصورة
$storeQuery = "SELECT id, name, governorate, image FROM stores WHERE id=?";
$storeStmt = $conn->prepare($storeQuery);
$storeStmt->bind_param("i", $store_id);
$storeStmt->execute();
$storeResult = $storeStmt->get_result();
$store = $storeResult->fetch_assoc() ?: [
    "id" => $store_id,
    "name" => "غير معروف",
    "governorate" => "غير محدد",
    "image" => "" // افتراضي: لا صورة
];

// ✅ جلب الفائزين الحاليين (حتى $max_winners فقط)
$query = "SELECT rw.id as raffle_id, rw.user_id, u.username, u.email, rw.prize_label, rw.claimed, rw.win_date 
          FROM raffle_winners rw
          LEFT JOIN users u ON rw.user_id = u.id
          WHERE rw.store_id=?
          ORDER BY rw.win_date ASC 
          LIMIT ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("ii", $store_id, $max_winners);
$stmt->execute();
$result = $stmt->get_result();

$winners = [];
while($row = $result->fetch_assoc()){
    // تجاهل الجوائز التي تمثل "حظ أوفر"
    if($row['prize_label'] === 'حظاً أوفر') continue;

    $email = $row['email'] ?? "unknown@example.com";
    
    // تقسيم البريد إلى الجزء قبل وبعد @ وإخفاء آخر حرف من الجزء الأول
    $parts = explode("@", $email);
    if(strlen($parts[0]) > 1){
        $parts[0] = substr($parts[0], 0, -1) . "***";
    } else {
        $parts[0] = $parts[0] . "***";
    }
    $masked_email = implode("@", $parts);

    $winners[] = [
        "raffle_id" => intval($row['raffle_id']),
        "user_id" => intval($row['user_id']),
        "username" => $masked_email,
        "prize_label" => $row['prize_label'],
        "claimed" => intval($row['claimed']),
        "win_date" => $row['win_date']
    ];
}


// ✅ إرسال الرد للتطبيق
echo json_encode([
    "success" => true,
    "store"    => [
        "id" => intval($store['id']),
        "name" => $store['name'],
        "governorate" => $store['governorate'],
        "image" => $store['image'] // هنا أضفنا حقل الصورة
    ],
    "prizes"   => $wheel_prizes,
    "winners"  => $winners,
    "ribbon_text" => $ribbon_text,
    "max_winners" => $max_winners,
    "offer_end_time" => $offer_end_time,
    "enable_wheel_tab" => $enable_wheel_tab 

], JSON_UNESCAPED_UNICODE);

$stmt->close();
$storeStmt->close();
$conn->close();
?>
