<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");

include 'db.php';
include 'auth.php';

$admin_id = authenticate(); // تحقق من المستخدم المسؤول

$data = json_decode(file_get_contents("php://input"));

if(!isset($data->raffle_id)){
    echo json_encode(["status"=>"error","message"=>"يجب تحديد معرف السحب"]);
    exit;
}

$raffle_id = intval($data->raffle_id);

$query = "UPDATE raffle_winners SET claimed=1 WHERE id=?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i",$raffle_id);

if($stmt->execute()){
    echo json_encode(["status"=>"success","message"=>"تم تحديث حالة الاستلام"]);
}else{
    echo json_encode(["status"=>"error","message"=>"فشل تحديث حالة الاستلام"]);
}

$stmt->close();
$conn->close();
?>
