<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

include 'db.php';
include 'auth.php';
include 'gift_settings.php'; // إعدادات الجوائز لكل حملة

// ============================
// تحقق من المستخدم
// ============================
$user_id = authenticate(); // JWT

// ============================
// تحقق من انتهاء العرض
// ============================
$current_time = time();
if ($offer_end_time > 0 && $current_time > $offer_end_time) {
    echo json_encode([
        "status" => "error",
        "message" => "انتهى العرض"
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

// ============================
// تحقق عدد محاولات المستخدم
// ============================
$checkQuery = "SELECT COUNT(*) AS total_attempts 
               FROM raffle_winners 
               WHERE user_id=? AND campaign_id=?";
$checkStmt = $conn->prepare($checkQuery);
$checkStmt->bind_param("ii", $user_id, $campaign_id);
$checkStmt->execute();
$total_attempts = $checkStmt->get_result()->fetch_assoc()['total_attempts'] ?? 0;

if (isset($max_attempts_per_user) && $total_attempts >= $max_attempts_per_user) {
    echo json_encode([
        "status" => "error",
        "message" => "لقد تجاوزت الحد المسموح للمشاركة في هذا العرض"
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

// ============================
// جلب الجوائز المتاحة حسب max_winners
// ============================
$available_prizes = [];

foreach ($wheel_prizes_detailed as $prize) {

    if ($prize['max_winners'] === null) {
        $available_prizes[] = $prize;
        continue;
    }

    $countPrizeQuery = "SELECT COUNT(*) AS total 
                        FROM raffle_winners 
                        WHERE campaign_id=? AND prize_label=?";
    $countPrizeStmt = $conn->prepare($countPrizeQuery);
    $countPrizeStmt->bind_param("is", $campaign_id, $prize['label']);
    $countPrizeStmt->execute();
    $totalForPrize = $countPrizeStmt->get_result()->fetch_assoc()['total'] ?? 0;
    $countPrizeStmt->close();

    if ($totalForPrize < $prize['max_winners']) {
        $available_prizes[] = $prize;
    }
}

// ============================
// تحقق من وجود جوائز
// ============================
$total_weight = array_sum(array_column($available_prizes, 'weight'));

if ($total_weight <= 0 || empty($available_prizes)) {
    echo json_encode([
        "status" => "error",
        "message" => "لا توجد جوائز متاحة حالياً"
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

// ============================
// اختيار الجائزة بالوزن (Server Authority)
// ============================
$rand = mt_rand() / mt_getrandmax() * $total_weight;
$prize_label = null;

foreach ($available_prizes as $prize) {
    if ($rand <= $prize['weight']) {
        $prize_label = $prize['label'];
        break;
    }
    $rand -= $prize['weight'];
}

// حماية إضافية
if ($prize_label === null) {
    $prize_label = $available_prizes[array_key_last($available_prizes)]['label'];
}

// ============================
// حساب prize_index (مهم جدًا)
// ============================
$prize_index = array_search($prize_label, $wheel_prizes, true);

if ($prize_index === false) {
    echo json_encode([
        "status" => "error",
        "message" => "خطأ في مطابقة الجائزة مع العجلة"
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

// ============================
// تسجيل الفوز
// ============================
$insertQuery = "INSERT INTO raffle_winners 
                (store_id, campaign_id, user_id, prize_label, claimed, win_date)
                VALUES (?,?,?,?,0,NOW())";
$insertStmt = $conn->prepare($insertQuery);
$insertStmt->bind_param("iiis", $store_id, $campaign_id, $user_id, $prize_label);

if ($insertStmt->execute()) {
    echo json_encode([
        "status" => "success",
        "message" => "تم تسجيل الفوز",
        "prize" => $prize_label,
        "prize_index" => $prize_index
    ], JSON_UNESCAPED_UNICODE);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "فشل تسجيل الفوز"
    ], JSON_UNESCAPED_UNICODE);
}

// ============================
// إغلاق الاتصالات
// ============================
$insertStmt->close();
$checkStmt->close();
$conn->close();
?>
