<?php
header('Content-Type: application/json; charset=UTF-8');

// الاتصال بقاعدة البيانات
include 'db.php';

// استقبال المعاملات
$page = isset($_GET['page']) ? intval($_GET['page']) : 0;
$limit = isset($_GET['limit']) ? intval($_GET['limit']) : 20;
$governorate = isset($_GET['governorate']) ? trim($_GET['governorate']) : null;
$name = isset($_GET['name']) ? trim($_GET['name']) : null;
$tier = isset($_GET['tier']) ? trim($_GET['tier']) : null;

$offset = $page * $limit;

// 🔒 الأساس: إظهار المتاجر الفعالة فقط
$sql = "
    SELECT id, name, description, phone, governorate, location, image, tier
    FROM stores
    WHERE is_active = 1
";

$params = [];
$types = "";

// فلتر المحافظة
if (!empty($governorate)) {
    $sql .= " AND governorate = ?";
    $params[] = $governorate;
    $types .= "s";
}

// فلتر الاسم
if (!empty($name)) {
    $sql .= " AND name LIKE ?";
    $params[] = "%$name%";
    $types .= "s";
}

// فلتر المستوى
if (!empty($tier)) {
    $sql .= " AND tier = ?";
    $params[] = $tier;
    $types .= "s";
}

// التصفح
$sql .= " LIMIT ?, ?";
$params[] = $offset;
$params[] = $limit;
$types .= "ii";

// تنفيذ الاستعلام
$stmt = $conn->prepare($sql);
if (!$stmt) {
    echo json_encode([
        "success" => false,
        "message" => "فشل في تحضير الاستعلام"
    ]);
    exit;
}

$stmt->bind_param($types, ...$params);
$stmt->execute();
$stmt->bind_result($id, $name, $description, $phone, $governorate, $location, $image, $tier);

// النتائج
$stores = [];
while ($stmt->fetch()) {
    $stores[] = [
        'id' => $id,
        'name' => $name,
        'description' => $description,
        'phone' => $phone,
        'governorate' => $governorate,
        'location' => $location,
        'image' => $image,
        'tier' => $tier
    ];
}

$stmt->close();

echo json_encode([
    'success' => true,
    'stores' => $stores
]);

$conn->close();
