<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include 'db.php';

// تأكد أن طريقة الطلب GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode([
        "status" => "error",
        "message" => "طريقة الطلب غير مدعومة"
    ]);
    exit;
}

// تأكد أن store_id مرسل
if (!isset($_GET['store_id'])) {
    echo json_encode([
        "status" => "error",
        "message" => "store_id مفقود"
    ]);
    exit;
}

$storeId = intval($_GET['store_id']);

if (!$conn) {
    echo json_encode([
        "status" => "error",
        "message" => "فشل الاتصال بقاعدة البيانات"
    ]);
    exit;
}

// استخدام مسار نسبي بدلاً من الرابط المطلق
$basePath = "/buymo_api/storePicUploads/";

$query = "SELECT 
              stores.id,
              stores.user_id,
              stores.name,
              stores.description,
              stores.phone,
              stores.governorate,
              stores.location,
              stores.image,
              stores.tier,
              stores.agent_id, 
              users.username AS owner
          FROM stores
          JOIN users ON stores.user_id = users.id
          WHERE stores.id = ?
          LIMIT 1";

$stmt = $conn->prepare($query);
if (!$stmt) {
    echo json_encode([
        "status" => "error",
        "message" => "فشل تجهيز الاستعلام"
    ]);
    exit;
}

$stmt->bind_param("i", $storeId);
$stmt->execute();
$stmt->bind_result(
    $id,
    $user_id,
    $name,
    $description,
    $phone,
    $governorate,
    $location,
    $image,
    $tier,
    $agent_id,  // تم إضافة هذا
    $owner
);
$hasStore = $stmt->fetch();
$stmt->close();

if ($hasStore) {
    // رابط الصورة النسبي
    if (!empty($image)) {
        $image = $basePath . $image;
    } else {
        $image = null;
    }

    $store = [
        'id' => $id,
        'user_id' => $user_id,
        'name' => $name,
        'description' => $description,
        'phone' => $phone,
        'governorate' => $governorate,
        'location' => $location,
        'image' => $image,
        'tier' => $tier,
        'agent_id' => $agent_id,
        'owner' => $owner
    ];

    echo json_encode([
        "status" => "success",
        "data" => $store
    ]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "المتجر غير موجود"
    ]);
}

$conn->close();
?>
