<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include 'db.php';

$store_id = isset($_GET['store_id']) ? intval($_GET['store_id']) : 0;

if ($store_id <= 0) {
    echo json_encode(["status" => "error", "message" => "معرف المتجر غير صالح"]);
    exit;
}

$query = "
    SELECT 
        p.id, p.store_id, p.name, p.category, p.description, p.image_url, 
        p.company, p.model, p.processor, p.ram, p.storage, p.gpu, p.battery, 
        p.price, p.updated_at,
        s.name AS store_name,
        s.phone AS store_phone,
        s.governorate AS store_governorate,
        s.location AS store_location,
        s.image AS store_image,
        s.tier AS store_tier,
        (
            SELECT COUNT(*) 
            FROM product_likes 
            WHERE product_id = p.id
        ) AS likes_count
    FROM products p
    LEFT JOIN stores s ON p.store_id = s.id
    WHERE p.store_id = ?
    ORDER BY p.updated_at DESC
";

$stmt = $conn->prepare($query);

if (!$stmt) {
    echo json_encode([
        "status" => "error", 
        "message" => "SQL Error: " . $conn->error,
        "query_preview" => substr($query, 0, 200)
    ]);
    exit;
}

$stmt->bind_param("i", $store_id);
$stmt->execute();
$stmt->bind_result($p_id, $p_store_id, $p_name, $p_category, $p_description, $p_image_url, $p_company, $p_model, $p_processor, $p_ram, $p_storage, $p_gpu, $p_battery, $p_price, $p_updated_at, $store_name, $store_phone, $store_governorate, $store_location, $store_image, $store_tier, $likes_count);

$products = [];

while ($stmt->fetch()) {
    $products[] = [
        'id' => $p_id,
        'store_id' => $p_store_id,
        'name' => $p_name,
        'category' => $p_category,
        'description' => $p_description,
        'image_url' => $p_image_url,
        'company' => $p_company,
        'model' => $p_model,
        'processor' => $p_processor,
        'ram' => $p_ram,
        'storage' => $p_storage,
        'gpu' => $p_gpu,
        'battery' => $p_battery,
        'price' => $p_price,
        'updated_at' => $p_updated_at,
        'store_name' => $store_name,
        'store_phone' => $store_phone,
        'store_governorate' => $store_governorate,
        'store_location' => $store_location,
        'store_image' => $store_image,
        'store_tier' => $store_tier,
        'likes_count' => $likes_count
    ];
}
$stmt->close();

echo json_encode(["status" => "success", "data" => $products]);
?>
