<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include 'db.php';

/* ========= المدخلات ========= */
$category    = isset($_GET['category']) ? trim($_GET['category']) : '';
$governorate = isset($_GET['governorate']) ? trim($_GET['governorate']) : '';
$offset      = isset($_GET['offset']) ? intval($_GET['offset']) : 0;
$limit       = isset($_GET['limit']) ? intval($_GET['limit']) : 10;

if (empty($category)) {
    echo json_encode([
        "status" => "error",
        "message" => "فئة المنتج مطلوبة"
    ]);
    exit;
}

/* ========= الاستعلام الأساسي ========= */
$query = "
    SELECT 
        p.id,
        p.store_id,
        p.name,
        p.category,
        p.description,
        p.image_url,
        p.company,
        p.model,
        p.processor,
        p.ram,
        p.storage,
        p.gpu,
        p.battery,
        p.price,
        p.updated_at,

        s.name AS store_name,
        s.phone AS store_phone,
        s.governorate AS store_governorate,
        s.location AS store_location,
        s.image AS store_image,
        s.tier AS store_tier,

        (
            SELECT COUNT(*) 
            FROM product_likes 
            WHERE product_id = p.id
        ) AS likes_count

    FROM products p
    INNER JOIN stores s 
        ON p.store_id = s.id
        AND s.is_active = 1
    WHERE p.category = ?
";

/* ========= الفلاتر ========= */
$params = [$category];
$types  = "s";

if (!empty($governorate) && $governorate !== 'all') {
    $query .= " AND s.governorate = ?";
    $params[] = $governorate;
    $types   .= "s";
}

/* ========= Pagination ========= */
$query .= " ORDER BY p.updated_at DESC LIMIT ?, ?";
$params[] = $offset;
$params[] = $limit;
$types   .= "ii";

/* ========= التنفيذ ========= */
$stmt = $conn->prepare($query);

if (!$stmt) {
    echo json_encode([
        "status" => "error",
        "message" => "SQL Error: " . $conn->error
    ]);
    exit;
}

$stmt->bind_param($types, ...$params);
$stmt->execute();

$result = $stmt->get_result();
$products = [];

while ($row = $result->fetch_assoc()) {
    $products[] = $row;
}

$stmt->close();
$conn->close();

/* ========= الإخراج ========= */
echo json_encode([
    "status" => "success",
    "data" => $products
]);
