<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include 'db.php';

$store_id = isset($_GET['store_id']) ? intval($_GET['store_id']) : 0;

if ($store_id <= 0) {
    echo json_encode([
        "status" => "error",
        "message" => "معرف المتجر غير صالح"
    ]);
    exit;
}

/*
    نربط المنتجات مع المتاجر
    ولا نرجع أي منتج إذا كان المتجر موقوف (is_active = 0)
*/
$query = "
    SELECT 
        p.id,
        p.name,
        p.category,
        p.description,
        p.image_url,
        p.company,
        p.model,
        p.processor,

        -- 🆕 CPU
        p.cpu_generation,
        p.cpu_speed,
        p.cpu_cores,

        p.ram,
        p.ram_type,

        p.storage,
        p.storage_type,

        p.gpu,
        p.battery,

        -- 🆕 Mobile
        p.os,
        p.screen_size,
        p.screen_resolution,
        p.front_camera,
        p.back_camera,
        p.network_support,

        -- 🆕 Physical
        p.weight,
        p.dimensions,

        p.price,
        p.updated_at
    FROM products p
    INNER JOIN stores s ON p.store_id = s.id
    WHERE p.store_id = ?
      AND s.is_active = 1
";

$stmt = $conn->prepare($query);

if (!$stmt) {
    echo json_encode([
        "status" => "error",
        "message" => "SQL Error",
        "details" => $conn->error
    ]);
    exit;
}

$stmt->bind_param("i", $store_id);
$stmt->execute();

$stmt->bind_result(
    $id,
    $name,
    $category,
    $description,
    $image_url,
    $company,
    $model,
    $processor,

    $cpu_generation,
    $cpu_speed,
    $cpu_cores,

    $ram,
    $ram_type,

    $storage,
    $storage_type,

    $gpu,
    $battery,

    $os,
    $screen_size,
    $screen_resolution,
    $front_camera,
    $back_camera,
    $network_support,

    $weight,
    $dimensions,

    $price,
    $updated_at
);

$products = [];

while ($stmt->fetch()) {
    $products[] = [
        'id' => $id,
        'name' => $name,
        'category' => $category,
        'description' => $description,
        'image_url' => $image_url,
        'company' => $company,
        'model' => $model,
        'processor' => $processor,

        'cpu_generation' => $cpu_generation,
        'cpu_speed' => $cpu_speed,
        'cpu_cores' => $cpu_cores,

        'ram' => $ram,
        'ram_type' => $ram_type,

        'storage' => $storage,
        'storage_type' => $storage_type,

        'gpu' => $gpu,
        'battery' => $battery,

        'os' => $os,
        'screen_size' => $screen_size,
        'screen_resolution' => $screen_resolution,
        'front_camera' => $front_camera,
        'back_camera' => $back_camera,
        'network_support' => $network_support,

        'weight' => $weight,
        'dimensions' => $dimensions,

        'price' => $price,
        'updated_at' => $updated_at
    ];
}

$stmt->close();

echo json_encode([
    "status" => "success",
    "data" => $products
]);
?>
