<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Authorization, Content-Type");
header("Content-Type: application/json; charset=UTF-8");

// القوائم الخاصة بكل فئة (محسنة الخيارات لكل حقل)
$options = [

    // ================== LAPTOP ==================
    "laptop" => [
        "companies" => [
            "Dell", "HP", "Lenovo", "Apple", "Acer", "Asus", "MSI", "Razer",
            "Microsoft", "Samsung", "LG", "Toshiba", "Fujitsu", "Huawei",
            "Xiaomi", "Chuwi", "Medion", "Clevo", "Alienware", "ROG"
        ],
        "processors" => [
            "Intel Core", "AMD Ryzen", "Apple M1", "Apple M2", "Qualcomm Snapdragon", "MediaTek", "Other"
        ],
        "ram" => [
            "2GB","4GB","8GB","12GB","16GB","24GB","32GB","64GB"
        ],
        "ram_type" => [
            "DDR2","DDR3","DDR4","DDR5","LPDDR3","LPDDR4","LPDDR4X","LPDDR5"
        ],
        "storage" => [
            "128GB","256GB","512GB","1TB","2TB","4TB","8TB"
        ],
        "storage_type" => [
            "HDD","SSD","NVMe SSD","eMMC","UFS"
        ],
        "gpu" => [
            "Intel","NVIDIA GeForce","NVIDIA RTX","AMD Radeon","Apple GPU","Other"
        ],
        "os" => [
            "Windows 10","Windows 11","Linux","Ubuntu","macOS Monterey","macOS Ventura"
        ],
        "screen_size" => [
            "11","12","13","14","15.6","16","17","17.3","18"
        ],
        "screen_resolution" => [
            "HD","Full HD","2K","4K","5K"
        ],
        "cpu_generation" => [
            "Gen 1","Gen 2","Gen 3","Gen 4","Gen 5","Gen 6","Gen 7","Gen 8","Gen 9","Gen 10","Gen 11","Gen 12","Gen 13","Gen 14","Gen 15"
        ],
        "cpu_speed" => [
            "1.0GHz","1.5GHz","2.0GHz","2.5GHz","3.0GHz","3.5GHz","4.0GHz","4.5GHz"
        ],
        "cpu_cores" => [
            "dualCore","core2due","coreI3","coreI5","coreI7","coreI9","6-core","8-core","12-core"
        ],
        "weight" => [
            "1kg","1.2kg","1.5kg","1.8kg","2kg","2.5kg","3kg","3.5kg","Other"
        ],
        "dimensions" => [
            "Slim","Standard","Large","Mini","Ultra Slim"
        ]
    ],

    // ================== MOBILE ==================
    "mobile" => [
        "companies" => [
            "Samsung","Xiaomi","Apple","Infinix","Oppo","Tecno",
            "Realme","Huawei","Nokia","Sony","Google","Motorola",
            "Vivo","OnePlus","Honor","Lenovo","Asus","Meizu"
        ],
        "processors" => [
            "Snapdragon","Exynos","MediaTek","Kirin",
            "Apple A-series","Google Tensor","Unisoc","Qualcomm"
        ],
        "ram" => [
            "2GB","3GB","4GB","6GB","8GB","12GB","16GB","24GB"
        ],

        "storage" => [
            "16GB","32GB","64GB","128GB","256GB","512GB","1TB"
        ],
        "storage_type" => [
            "eMMC","UFS 2.1","UFS 3.0","UFS 3.1","NVMe"
        ],
        "os" => [
            "Android","iOS"
        ],
        "screen_size" => [
            "4.5","5","5.5","6","6.2","6.5","6.7","7","7.2","10","12"
        ],
        "screen_resolution" =>[
            "IPS LCD",  "TFT LCD",  "OLED",  "AMOLED",  "Super AMOLED", "Dynamic AMOLED","Retina","P-OLED", "Mini-LED"],
        "front_camera" => [
             "1MP","2MP","3MP","5MP","8MP","10MP","12MP","13MP","16MP","20MP","24MP","32MP","40MP","48MP","50MP","60MP","64MP","100MP"
        ],

        "back_camera" => [
            "8MP","12MP","16MP","20MP","24MP","32MP","40MP","48MP","50MP","64MP","100MP","108MP","150MP","200MP","250MP","300MP","400MP","500MP"
        ],

        "network_support" => [
            "3G","4G","5G", "just Wi-Fi"

        ],
        "weight" => [
            "120g","150g","170g","190g","210g","230g","250g"
        ],
        "dimensions" => [
            "Compact","Standard","Large","Slim"
        ]
    ]
];

// إخراج النتيجة
echo json_encode([
    "status" => "success",
    "data" => $options
], JSON_UNESCAPED_UNICODE);
