<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include 'db.php';

// جلب product_id من GET أو POST
$product_id = isset($_GET['product_id']) ? intval($_GET['product_id']) : 0;

if ($product_id <= 0) {
    echo json_encode([
        "status" => "error",
        "message" => "معرف المنتج غير صالح"
    ]);
    exit;
}

// استعلام لجلب بيانات المنتج مع بيانات المتجر
$query = "
    SELECT 
        p.id,
        p.store_id,
        p.name,
        p.category,
        p.description,
        p.image_url,
        p.company,
        p.model,
        p.processor,
        p.cpu_generation,
        p.cpu_speed,
        p.cpu_cores,
        p.ram,
        p.ram_type,
        p.storage,
        p.storage_type,
        p.gpu,
        p.battery,
        p.os,
        p.screen_size,
        p.screen_resolution,
        p.front_camera,
        p.back_camera,
        p.network_support,
        p.weight,
        p.dimensions,
        p.price,
        p.likes_count,
        p.updated_at,
        s.name AS store_name,
        s.phone AS store_phone,
        s.governorate AS store_governorate,
        s.location AS store_location,
        s.image AS store_image,
        s.tier AS store_tier
    FROM products p
    INNER JOIN stores s ON p.store_id = s.id
    WHERE p.id = ? AND s.is_active = 1
    LIMIT 1
";

$stmt = $conn->prepare($query);

if (!$stmt) {
    echo json_encode([
        "status" => "error",
        "message" => "SQL Error",
        "details" => $conn->error
    ]);
    exit;
}

$stmt->bind_param("i", $product_id);
$stmt->execute();

$result = $stmt->get_result();
$product = $result->fetch_assoc();

$stmt->close();

if (!$product) {
    echo json_encode([
        "status" => "error",
        "message" => "المنتج غير موجود أو المتجر غير نشط"
    ]);
    exit;
}

echo json_encode([
    "status" => "success",
    "data" => $product
]);
?>
