<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

require_once __DIR__ . '/auth.php';
require_once "db.php";

// 1️⃣ مصادقة المستخدم
$userId = authenticate();

// 2️⃣ استعلام جلب الإشعارات
//    - إشعارات عامة (user_id IS NULL)
//    - إشعارات مخصصة للمستخدم (user_id = هذا المستخدم)
$sql = "
SELECT n.id, n.title, n.message, n.created_at,
       CASE WHEN r.id IS NOT NULL THEN 1 ELSE 0 END AS is_read
FROM notifications n
LEFT JOIN notification_reads r 
      ON n.id = r.notification_id AND r.user_id = ?
WHERE n.user_id IS NULL OR n.user_id = ?
ORDER BY n.created_at DESC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $userId, $userId);
$stmt->execute();
$stmt->bind_result($notif_id, $title, $message, $created_at, $is_read);

$notifications = [];
$unreadCount = 0;

// 3️⃣ معالجة النتائج
while ($stmt->fetch()) {
    if ($is_read == 0) {
        $unreadCount++;
    }
    $notifications[] = [
        'id' => $notif_id,
        'title' => $title,
        'message' => $message,
        'created_at' => $created_at,
        'is_read' => $is_read
    ];
}

$stmt->close();

// 4️⃣ إرسال النتيجة JSON للتطبيق
echo json_encode([
    "status" => "success",
    "unread_count" => $unreadCount,
    "notifications" => $notifications
]);
?>
