<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';

$userId = authenticate();

$data = json_decode(file_get_contents("php://input"), true);
$type = $data['type'] ?? 'all';
$search = $data['search'] ?? '';
$governorateFilter = $data['governorate'] ?? ''; // فلترة اختيارية حسب المحافظة

$sql = "
    SELECT
        id,
        user_id,
        type,
        part_name,
        contact_phone,
        governorate,
        is_active,
        created_at
    FROM market_requests
    WHERE (
        is_active IN (0,1)
        OR (is_active = 2 AND user_id = ?)
    )
    AND is_active != 3
";

$params = [$userId];
$types = "i";

// إذا جاء 'category' من Flutter، اعتبره 'all'
if ($type === 'category') {
    $type = 'all';
}

if (!empty($search)) {
    $sql .= " AND part_name LIKE ?";
    $params[] = "%$search%";
    $types .= "s";
}

if (!empty($governorateFilter)) {
    $sql .= " AND governorate = ?";
    $params[] = $governorateFilter;
    $types .= "s";
}

/* ✅ الإصلاح الوحيد: فلترة المطلوب / المتوفر */
if ($type !== 'all') {
    $sql .= " AND type = ?";
    $params[] = $type;
    $types .= "s";
}

$sql .= " ORDER BY created_at DESC";

$stmt = $conn->prepare($sql);
$stmt->bind_param($types, ...$params);
$stmt->execute();

$result = $stmt->get_result();
$rows = [];
while ($row = $result->fetch_assoc()) {
    $rows[] = $row;
}

echo json_encode([
    "success" => true,
    "data" => $rows
]);
