<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

require_once __DIR__ . '/auth.php';
require_once("db.php");

$userId = authenticate();

// قراءة بيانات POST
$rawInput = file_get_contents("php://input");
$data = json_decode($rawInput, true);

// جلب limit و offset من باراميترات GET، مع قيم افتراضية
$limit = isset($_GET['limit']) ? intval($_GET['limit']) : 50;
$offset = isset($_GET['offset']) ? intval($_GET['offset']) : 0;

if ($limit <= 0) $limit = 10;
if ($offset < 0) $offset = 0;

// الاستعلام مع دعم limit و offset
$query = $conn->prepare("
  SELECT p.id, p.store_id, p.name, p.category, p.description, p.image_url, 
         p.company, p.model, p.processor, p.ram, p.storage, p.gpu, p.battery, 
         p.price, p.likes_count, p.updated_at,
         s.name AS store_name, 
         s.image AS store_image, 
         s.phone AS store_phone, 
         s.governorate AS store_governorate
  FROM product_likes pl
  JOIN products p ON pl.product_id = p.id
  JOIN stores s ON p.store_id = s.id
  WHERE pl.user_id = ?
  ORDER BY pl.created_at DESC
  LIMIT ? OFFSET ?
");

if (!$query) {
    echo json_encode([
        "status" => "error",
        "message" => "SQL Error: " . $conn->error
    ]);
    exit;
}

$query->bind_param("iii", $userId, $limit, $offset);
$query->execute();
$query->bind_result(
    $p_id,
    $p_store_id,
    $p_name,
    $p_category,
    $p_description,
    $p_image_url,
    $p_company,
    $p_model,
    $p_processor,
    $p_ram,
    $p_storage,
    $p_gpu,
    $p_battery,
    $p_price,
    $p_likes_count,
    $p_updated_at,
    $store_name,
    $store_image,
    $store_phone,
    $store_governorate
);

$products = [];
while ($query->fetch()) {
    $products[] = [
        'id' => $p_id,
        'store_id' => $p_store_id,
        'name' => $p_name,
        'category' => $p_category,
        'description' => $p_description,
        'image_url' => $p_image_url,
        'company' => $p_company,
        'model' => $p_model,
        'processor' => $p_processor,
        'ram' => $p_ram,
        'storage' => $p_storage,
        'gpu' => $p_gpu,
        'battery' => $p_battery,
        'price' => $p_price,
        'likes_count' => $p_likes_count,
        'updated_at' => $p_updated_at,
        'store_name' => $store_name ?? '',
        'store_image' => $store_image ?? '',
        'store_phone' => $store_phone ?? '',
        'store_governorate' => $store_governorate ?? ''
    ];
}

$query->close();

echo json_encode([
    "status" => "success",
    "data" => $products
]);

$conn->close();
?>
