<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include 'db.php'; // الاتصال بقاعدة البيانات

try {
    // ==========================
    // أعلى 5 منتجات إعجابًا فقط
    // ==========================
    $products = [];
    $productQuery = "
        SELECT 
            p.id, p.store_id, p.name, p.category, p.description, p.image_url, p.company, p.model, 
            p.processor, p.ram, p.storage, p.gpu, p.battery, p.price,
            s.name AS store_name, s.phone AS store_phone, s.governorate AS store_governorate, 
            s.location AS store_location, s.image AS store_image, s.tier AS store_tier,
            p.likes_count
        FROM products p
        LEFT JOIN stores s ON p.store_id = s.id
        ORDER BY p.likes_count DESC
        LIMIT 7
    ";
    $result = $conn->query($productQuery);

    if ($result !== false) {
        while ($row = $result->fetch_assoc()) {
            $products[] = $row;
        }
    }

    // ==========================
    // إخراج JSON موحد
    // ==========================
    echo json_encode([
        'success' => true,
        'products' => $products
    ], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => "حدث خطأ: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}

$conn->close();
?>
