<?php
header('Content-Type: application/json; charset=UTF-8');
include 'db.php'; // الاتصال بقاعدة البيانات

// ==========================
// نسخة البانرات (قم بتغييرها عند أي تحديث للصور)
// ==========================
$bannerVersion = 0;

// ==========================
// IDs المتاجر المميزة
// ==========================
$featuredStoreIds = [80, 73, 76]; // عدل حسب الحاجة

// ==========================
// مصفوفة البانر: اسم الصورة + رابط
// ==========================
$bannerImages = [
    'ad1.png' => 'https://www.instagram.com/doraidzahra/',
    'ad2.png' => 'https://www.facebook.com/share/1Bp3npRSEF',
    'ad3.png' => 'https://www.instagram.com/doraidzahra',
];

$banners = [];
foreach ($bannerImages as $image => $url) {
    $banners[] = [
        'image' => $image,
        'link_url' => $url
    ];
}

// ==========================
// جلب المتاجر المميزة
// ==========================
$stores = [];

if (count($featuredStoreIds) > 0) {
    // تحويل IDs إلى سلسلة مفصولة بفاصلة
    $ids = implode(',', $featuredStoreIds);

    // الاستعلام
    $sql = "SELECT id, name, description, phone, governorate, location, image, tier 
            FROM stores 
            WHERE id IN ($ids) 
            ORDER BY FIELD(id, $ids)";

    $result = $conn->query($sql);

    if ($result) {
        while ($row = $result->fetch_assoc()) {
            $stores[] = [
                "id"          => (int)$row['id'],
                "name"        => $row['name'],
                "description" => $row['description'],
                "phone"       => $row['phone'],
                "governorate" => $row['governorate'],
                "location"    => $row['location'],
                "image"       => $row['image'],
                "tier"        => $row['tier'],
            ];
        }
    }
}

// ==========================
// إعادة الاستجابة JSON
// ==========================
echo json_encode([
    'success' => true,
    'stores' => $stores,
    'banners' => $banners,
    'banner_version' => $bannerVersion
], JSON_UNESCAPED_UNICODE);

$conn->close();
?>
