<?php
header('Content-Type: application/json; charset=UTF-8');

// التحقق من وجود اسم المحافظة
if (!isset($_GET['governorate']) || empty($_GET['governorate'])) {
    echo json_encode([
        "status" => "error",
        "message" => "لم يتم تحديد المحافظة"
    ]);
    exit;
}

$governorate = $_GET['governorate'];

// قائمة الموزعين لكل محافظة
$agents_by_governorate = [
    "دمشق" => [
        ["id" => "App 0997636706", "name" => "App Supervisor"]
    ],
    "ريف دمشق" => [
        ["id" => "App 0997636706", "name" => "App Supervisor"]
    ],
    "حلب" => [
        ["id" => "App 0997636706", "name" => "App Supervisor"]
    ],
    "حماة" => [
        ["id" => "App 0997636706", "name" => "App Supervisor"]
    ],
    "حمص" => [
        ["id" => "App 0997636706", "name" => "App Supervisor"]
    ],
    "اللاذقية" => [
        ["id" => "App 0997636706", "name" => "App Supervisor"],
        ["id" => "Hossen 0934801666", "name" => "Hossen Aboud"]
    ],
    "جبلة" => [
        ["id" => "App 0997636706", "name" => "App Supervisor"]
    ],
    "طرطوس" => [
        ["id" => "App 0997636706", "name" => "App Supervisor"]
    ],
    "إدلب" => [
        ["id" => "App 0997636706", "name" => "App Supervisor"]
    ],
    "الحسكة" => [
        ["id" => "App 0997636706", "name" => "App Supervisor"]
    ],
    "دير الزور" => [
        ["id" => "App 0997636706", "name" => "App Supervisor"]
    ],
    "الرقة" => [
        ["id" => "App 0997636706", "name" => "App Supervisor"]
    ],
    "السويداء" => [
        ["id" => "App 0997636706", "name" => "App Supervisor"]
    ],
    "درعا" => [
        ["id" => "App 0997636706", "name" => "App Supervisor"]
    ],
    "القنيطرة" => [
        ["id" => "App 0997636706", "name" => "App Supervisor"]
    ]
];

// التحقق إذا كانت المحافظة موجودة في القائمة
if (isset($agents_by_governorate[$governorate])) {
    echo json_encode([
        "status" => "success",
        "agents" => $agents_by_governorate[$governorate]
    ]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "لا يوجد موزعين لهذه المحافظة"
    ]);
}
