<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

require_once __DIR__ . '/auth.php';
require_once 'db.php';

$userId = authenticate();

$data = json_decode(file_get_contents('php://input'), true);
$product_id = $data['product_id'] ?? 0;

if (!$product_id) {
    echo json_encode(["status" => "error", "message" => "معرف المنتج غير صالح"]);
    exit;
}

// ✅ احصل على مسار الصورة للمنتج المحدد
$stmt = $conn->prepare("SELECT image_url FROM user_guest_products WHERE id = ? AND user_id = ?");
$stmt->bind_param("ii", $product_id, $userId);
$stmt->execute();
$stmt->bind_result($imagePath);
$stmt->fetch();
$stmt->close();

// حذف الصورة من السيرفر إذا وجدت
if (!empty($imagePath)) {
    $fullPath = __DIR__ . "/" . $imagePath; // عدل حسب مسار التخزين
    if (file_exists($fullPath)) {
        unlink($fullPath);
    }
}

// ✅ احذف المنتج نفسه
$stmt = $conn->prepare("DELETE FROM user_guest_products WHERE id = ? AND user_id = ?");
$stmt->bind_param("ii", $product_id, $userId);

if ($stmt->execute()) {
    if ($stmt->affected_rows > 0) {
        echo json_encode(["status" => "success", "message" => "تم حذف المنتج والصورة بنجاح"]);
    } else {
        echo json_encode(["status" => "error", "message" => "لم يتم العثور على المنتج"]);
    }
} else {
    echo json_encode([
        "status" => "error",
        "message" => "خطأ SQL: " . $stmt->error
    ]);
}

$stmt->close();
$conn->close();
?>
