<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

require_once __DIR__ . '/auth.php';
require_once 'db.php';

$userId = authenticate();

$user_id = $userId;

// بدء المعاملة
$conn->begin_transaction();

try {
    // 1️⃣ حذف صور أجهزة المستخدم
    $stmt = $conn->prepare("SELECT image_url FROM user_guest_products WHERE user_id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $stmt->bind_result($imagePath);
    while ($stmt->fetch()) {
        if (!empty($imagePath)) {
            $fullPath = __DIR__ . "/" . $imagePath;
            if (file_exists($fullPath)) {
                unlink($fullPath);
            }
        }
    }
    $stmt->close();

    // حذف أجهزة المستخدم
    $stmt = $conn->prepare("DELETE FROM user_guest_products WHERE user_id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $stmt->close();

    // 2️⃣ الحصول على متجر المستخدم (إن وجد)
    $stmt = $conn->prepare("SELECT id, image FROM stores WHERE user_id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $stmt->bind_result($storeId, $storeImage);
    $storeIds = [];
    $storeImages = [];
    while ($stmt->fetch()) {
        $storeIds[] = $storeId;
        $storeImages[$storeId] = $storeImage; // حفظ اسم صورة المتجر
    }
    $stmt->close();

    foreach ($storeIds as $store_id) {
        // 2a️⃣ حذف صور منتجات المتجر
        $stmt = $conn->prepare("SELECT image_url FROM products WHERE store_id = ?");
        $stmt->bind_param("i", $store_id);
        $stmt->execute();
        $stmt->bind_result($productImagePath);
        while ($stmt->fetch()) {
            if (!empty($productImagePath)) {
                $fullPath = __DIR__ . "/storePicUploads/" . $productImagePath;
                if (file_exists($fullPath)) {
                    unlink($fullPath);
                }
            }
        }
        $stmt->close();

        // 2b️⃣ حذف المنتجات من المتجر
        $stmt = $conn->prepare("DELETE FROM products WHERE store_id = ?");
        $stmt->bind_param("i", $store_id);
        $stmt->execute();
        $stmt->close();

        // 2c️⃣ حذف صورة المتجر نفسه من السيرفر
        if (!empty($storeImages[$store_id])) {
            $storeImagePath = __DIR__ . "/storePicUploads/" . $storeImages[$store_id];
            if (file_exists($storeImagePath)) {
                unlink($storeImagePath);
            }
        }

        // 2d️⃣ حذف المتجر نفسه من قاعدة البيانات
        $stmt = $conn->prepare("DELETE FROM stores WHERE id = ?");
        $stmt->bind_param("i", $store_id);
        $stmt->execute();
        $stmt->close();
    }

    // 3️⃣ حذف المستخدم نفسه
    $stmt = $conn->prepare("DELETE FROM users WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $stmt->close();

    $conn->commit();
    echo json_encode(["status" => "success", "message" => "تم حذف الحساب وكل متعلقاته بما فيها الصور والمتجر والمنتجات"]);

} catch (Exception $e) {
    $conn->rollback();
    echo json_encode(["status" => "error", "message" => "فشل حذف الحساب: " . $e->getMessage()]);
}

$conn->close();
?>
