<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

require_once __DIR__ . '/auth.php';
include 'db.php';

$userId = authenticate();

$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['store_id'])) {
    echo json_encode(["status" => "error", "message" => "store_id مفقود"]);
    exit;
}

$store_id = intval($data['store_id']);
$user_id = $userId;

// تحقق ملكية المتجر
$stmt = $conn->prepare("SELECT user_id FROM stores WHERE id = ?");
$stmt->bind_param("i", $store_id);
$stmt->execute();
$stmt->bind_result($storeOwnerId);
$hasStore = $stmt->fetch();
$stmt->close();

if (!$hasStore || $storeOwnerId !== $user_id) {
    echo json_encode(["status" => "error", "message" => "ليس لديك صلاحية لحذف هذا المتجر"]);
    exit;
}

// جلب المنتجات المرتبطة بالمتجر
$stmt = $conn->prepare("SELECT id, image_url FROM products WHERE store_id = ?");
$stmt->bind_param("i", $store_id);
$stmt->execute();
$stmt->bind_result($productId, $productImageUrl);

$product_ids = [];
$image_files = [];
while ($stmt->fetch()) {
    $product_ids[] = $productId;
    if (!empty($productImageUrl)) {
        $image_files[] = $productImageUrl;
    }
}
$stmt->close();

// حذف اللايكات المرتبطة بكل منتج
if (!empty($product_ids)) {
    $in  = implode(',', array_fill(0, count($product_ids), '?'));
    $types = str_repeat('i', count($product_ids));
    $stmt = $conn->prepare("DELETE FROM product_likes WHERE product_id IN ($in)");

    $refs = [];
    foreach ($product_ids as $key => $id) {
        $refs[$key] = &$product_ids[$key];
    }
    array_unshift($refs, $types);
    call_user_func_array([$stmt, 'bind_param'], $refs);

    $stmt->execute();
    $stmt->close();
}

// حذف المنتجات
$stmt = $conn->prepare("DELETE FROM products WHERE store_id = ?");
$stmt->bind_param("i", $store_id);
$stmt->execute();
$stmt->close();

// حذف ملفات صور المنتجات من السيرفر
foreach ($image_files as $file) {
    $path = __DIR__ . "/storePicUploads/" . $file;
    if (file_exists($path)) {
        unlink($path);
    }
}

// حذف صورة المتجر من السيرفر إذا كانت موجودة
$stmt = $conn->prepare("SELECT image FROM stores WHERE id = ?");
$stmt->bind_param("i", $store_id);
$stmt->execute();
$stmt->bind_result($storeImageFilename);
$stmt->fetch();
$stmt->close();

if (!empty($storeImageFilename)) {
    $storeImagePath = __DIR__ . "/storePicUploads/" . $storeImageFilename;
    if (file_exists($storeImagePath)) {
        unlink($storeImagePath);
    }
}

// حذف المتجر
$stmt = $conn->prepare("DELETE FROM stores WHERE id = ?");
$stmt->bind_param("i", $store_id);
if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "تم حذف المتجر والمنتجات والإعجابات وصورة المتجر بنجاح"]);
} else {
    echo json_encode(["status" => "error", "message" => "فشل حذف المتجر"]);
}
$stmt->close();
$conn->close();
?>
