<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

require_once __DIR__ . '/auth.php';
include 'db.php';

$userId = authenticate();

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->id)) {
    $id = intval($data->id);

    // التحقق من ملكية المنتج
    $ownershipQuery = "SELECT p.image_url FROM products p 
                       INNER JOIN stores s ON p.store_id = s.id 
                       WHERE p.id = ? AND s.user_id = ?";
    $stmtOwnership = $conn->prepare($ownershipQuery);
    $stmtOwnership->bind_param("ii", $id, $userId);
    $stmtOwnership->execute();
    $stmtOwnership->bind_result($imageFilename);
    $hasOwnership = $stmtOwnership->fetch();
    $stmtOwnership->close();

    if (!$hasOwnership) {
        echo json_encode(["status" => "error", "message" => "المنتج غير موجود أو ليس لديك صلاحية لحذفه."]);
        exit;
    }

    // احذف اللايكات المرتبطة بالمنتج
    $deleteLikes = $conn->prepare("DELETE FROM product_likes WHERE product_id = ?");
    $deleteLikes->bind_param("i", $id);
    $deleteLikes->execute();
    $deleteLikes->close();

    // حذف المنتج من قاعدة البيانات
    $deleteQuery = "DELETE FROM products WHERE id = ?";
    $deleteStmt = $conn->prepare($deleteQuery);
    $deleteStmt->bind_param("i", $id);

    if ($deleteStmt->execute()) {
        // حذف ملف الصورة من السيرفر (إذا كان موجود)
        if (!empty($imageFilename)) {
            $filePath = __DIR__ . "/storePicUploads/" . $imageFilename;
            if (file_exists($filePath)) {
                unlink($filePath);
            }
        }

        echo json_encode(["status" => "success", "message" => "تم حذف المنتج والصورة واللايكات بنجاح."]);
    } else {
        echo json_encode(["status" => "error", "message" => "فشل في حذف المنتج."]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "رقم المنتج مطلوب."]);
}
?>
