<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

require_once __DIR__ . '/auth.php';
include 'db.php';

$userId = authenticate();

if (
    isset($_POST['name']) && !empty($_POST['name'])
) {
    $user_id = $userId;
    $name = htmlspecialchars(strip_tags($_POST['name']));
    $description = isset($_POST['description']) ? htmlspecialchars(strip_tags($_POST['description'])) : "";
    $phone = isset($_POST['phone']) ? htmlspecialchars(strip_tags($_POST['phone'])) : "";
    $governorate = isset($_POST['governorate']) ? htmlspecialchars(strip_tags($_POST['governorate'])) : "";
    $location = isset($_POST['location']) ? htmlspecialchars(strip_tags($_POST['location'])) : null;
    // هنا تعديل: agent_id نصي وليس عددي
    $agent_id = isset($_POST['agent_id']) ? htmlspecialchars(strip_tags($_POST['agent_id'])) : null;

    $imageName = null;

    // التعامل مع الصورة إن وُجدت
    if (isset($_FILES['image']) && $_FILES['image']['error'] !== UPLOAD_ERR_NO_FILE) {
        $image = $_FILES['image'];
        $maxFileSize = 250 * 1024; // 250 KB

        if ($image['error'] === UPLOAD_ERR_OK) {
            if ($image['size'] <= $maxFileSize) {
                $check = getimagesize($image['tmp_name']);
                if ($check !== false) {
                    $ext = strtolower(pathinfo($image['name'], PATHINFO_EXTENSION));
                    $newFileName = uniqid('store_', true) . '.' . $ext;

                    $target_dir = "storePicUploads/";
                    if (!is_dir($target_dir)) {
                        mkdir($target_dir, 0755, true);
                    }
                    $target_file = $target_dir . $newFileName;

                    if (move_uploaded_file($image['tmp_name'], $target_file)) {
                        $imageName = $newFileName;
                    } else {
                        echo json_encode(["status" => "error", "message" => "فشل في رفع الصورة"]);
                        exit;
                    }
                } else {
                    echo json_encode(["status" => "error", "message" => "الملف المرفوع ليس صورة صالحة"]);
                    exit;
                }
            } else {
                echo json_encode(["status" => "error", "message" => "حجم الصورة أكبر من 250 كيلوبايت"]);
                exit;
            }
        } else {
            echo json_encode(["status" => "error", "message" => "حدث خطأ أثناء رفع الصورة"]);
            exit;
        }
    }

    // تجهيز جملة الإدخال
    $query = "INSERT INTO stores (user_id, name, description, phone, governorate, location, image, agent_id)
              VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($query);
    $stmt->bind_param(
        "isssssss",
        $user_id,
        $name,
        $description,
        $phone,
        $governorate,
        $location,
        $imageName,
        $agent_id
    );

    if ($stmt->execute()) {
        echo json_encode([
            "status" => "success",
            "message" => "تم إنشاء المتجر بنجاح",
            "store_id" => $stmt->insert_id,
            "image" => $imageName
        ]);
    } else {
        // حذف الصورة في حال فشل الإدخال
        if ($imageName && file_exists("storePicUploads/$imageName")) {
            unlink("storePicUploads/$imageName");
        }
        echo json_encode(["status" => "error", "message" => "فشل في إنشاء المتجر"]);
    }

    $stmt->close();
} else {
    echo json_encode(["status" => "error", "message" => "يرجى تعبئة الحقول الأساسية (name)"]);
}

$conn->close();
?>
