<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include __DIR__ . '/../db.php';

if(!isset($_SESSION['role']) || $_SESSION['role'] != 'admin'){
    die("غير مصرح بالدخول");
}

$winners = [];
$error_message = '';
$fetch_results = false;

if (isset($_POST['fetch_winners'])) {
    $fetch_results = true;
    $store_id = $_POST['store_id'] ?? '';
    $campaign_id = $_POST['campaign_id'] ?? '';
    $exclude_better_luck = isset($_POST['exclude_better_luck']);

    // استخدام LEFT JOIN لتجنب فقد الصفوف
    $sql = "SELECT rw.*, 
                   COALESCE(u.username, rw.username) AS user_name, 
                   u.email AS user_email,
                   s.name AS store_name, 
                   s.phone AS store_phone, 
                   s.governorate AS store_governorate
            FROM raffle_winners rw
            LEFT JOIN users u ON rw.user_id = u.id
            LEFT JOIN stores s ON rw.store_id = s.id
            WHERE 1=1";

    $params = [];
    $types = '';

    if ($store_id !== '') {
        $sql .= " AND rw.store_id = ?";
        $params[] = $store_id;
        $types .= 'i';
    }

    if ($campaign_id !== '') {
        $sql .= " AND rw.campaign_id = ?";
        $params[] = $campaign_id;
        $types .= 'i';
    }

    if ($exclude_better_luck) {
        $sql .= " AND rw.prize_label != 'حظاً أوفر'";
    }

    $sql .= " ORDER BY rw.win_date DESC LIMIT 500";

    try {
        $stmt = $conn->prepare($sql);
        if ($params) $stmt->bind_param($types, ...$params);
        $stmt->execute();
        $result = $stmt->get_result();
        $winners = $result->fetch_all(MYSQLI_ASSOC);
        $stmt->close();
    } catch (mysqli_sql_exception $e) {
        $error_message = "خطأ في جلب البيانات: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>الفائزون - إدارة العجلة</title>
<style>
body { font-family: Tahoma, Arial, sans-serif; background: #f4f6f8; padding: 20px; color:#333; max-width:1200px; margin:auto; }
.table-wrapper { overflow-x:auto; background:#fff; border-radius:6px; padding:10px; }
table { width:100%; border-collapse:collapse; }
th, td { border:1px solid #ddd; padding:6px 8px; text-align:center; font-size:13px; }
th { background:#f0f0f0; font-weight:bold; }
.error { background:#f44336; color:#fff; padding:6px 10px; border-radius:4px; margin-bottom:10px; }
</style>
</head>
<body>

<h2>🎁 قائمة الفائزين بالعجلة</h2>

<?php if($error_message): ?>
<div class="error"><?= htmlspecialchars($error_message) ?></div>
<?php endif; ?>

<form method="post" style="margin-bottom:1.5rem; background:#fff; padding:12px; border-radius:6px;">
    <label>رقم المتجر: <input type="number" name="store_id" value="<?= htmlspecialchars($_POST['store_id'] ?? '') ?>"></label>
    <label>رقم الإصدار: <input type="number" name="campaign_id" value="<?= htmlspecialchars($_POST['campaign_id'] ?? '') ?>"></label>
    <label>
        <input type="checkbox" name="exclude_better_luck" <?= isset($_POST['exclude_better_luck']) ? 'checked' : '' ?>>
        عدم جلب حظ أوفر
    </label>
    <button type="submit" name="fetch_winners">✅ موافق</button>
</form>

<?php if($fetch_results): ?>
<h3>عدد النتائج: <?= count($winners) ?></h3>
<div class="table-wrapper">
    <table>
        <thead>
            <tr>
                <th>رقم الفائز</th>
                <th>اسم المستخدم</th>
                <th>البريد الإلكتروني</th>
                <th>الجائزة</th>
                <th>رقم المتجر</th>
                <th>اسم المتجر</th>
                <th>رقم الإصدار</th>
                <th>تاريخ الفوز</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($winners as $w): ?>
            <tr>
                <td><?= $w['id'] ?></td>
                <td><?= htmlspecialchars($w['user_name'] ?? '-') ?></td>
                <td><?= htmlspecialchars($w['user_email'] ?? '-') ?></td>
                <td><?= htmlspecialchars($w['prize_label']) ?></td>
                <td><?= htmlspecialchars($w['store_id']) ?></td>
                <td><?= htmlspecialchars($w['store_name'] ?? '-') ?></td>
                <td><?= htmlspecialchars($w['campaign_id']) ?></td>
                <td><?= htmlspecialchars($w['win_date']) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
<?php endif; ?>

</body>
</html>
