<?php
// tiers_prices.php

return [
    // الأسعار الشهرية لكل مستوى
    'tiers' => [
        'FREE' => 0,
        'SILVER' => 5,
        'GOLD' => 8,
        'PLATINUM' => 11,
        'DIMOUND' => 15,
        'VIP' => 20,
    ],

    // الخصومات حسب مدة الاشتراك
    'discounts' => [
        'monthly' => 0,        // بدون خصم
        'semi-annual' => 17,   // خصم 17%
        'yearly' => 21,        // خصم 21%
    ],

    // دالة لحساب السعر النهائي تلقائياً
    'calculate_price' => function($tier, $subscription_type) {
        $tiers = [
            'FREE' => 0,
            'SILVER' => 5,
            'GOLD' => 8,
            'PLATINUM' => 11,
            'DIMOUND' => 15,
            'VIP' => 20,
        ];

        $discounts = [
            'monthly' => 0,
            'semi-annual' => 17,
            'yearly' => 21,
        ];

        $base = $tiers[$tier] ?? 0;

        // المبلغ قبل الخصم حسب المدة
        $multiplier = 1;
        if ($subscription_type === 'semi-annual') $multiplier = 6;
        elseif ($subscription_type === 'yearly') $multiplier = 12;

        $total = $base * $multiplier;

        // تطبيق الخصم
        $discount_percent = $discounts[$subscription_type] ?? 0;
        $final = $total * (1 - $discount_percent / 100);

        return round($final, 2); // تقريب لأقرب سنت
    }
];
