<?php
include "config.php";

if(!isset($_SESSION['role']) || $_SESSION['role'] != 'admin'){
    die("غير مصرح بالدخول");
}

if(isset($_POST['change_role'])){
    $user_id = intval($_POST['user_id']);
    $new_role = $_POST['new_role'];
    $stmt = $conn->prepare("UPDATE users SET role=? WHERE id=?");
    $stmt->bind_param("si", $new_role, $user_id);
    $stmt->execute();
}

if(isset($_POST['delete_user'])){
    $user_id = intval($_POST['user_id']);
    $stmt = $conn->prepare("DELETE FROM users WHERE id=?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
}

$res = $conn->query("SELECT id, username, email, phone, role FROM users ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة المستخدمين</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>

<div class="nav-bar">
    <div class="nav-links">
        <a href="admin_stats.php" class="btn btn-home">
            <span class="btn-icon">🏠</span>
            الرئيسية
        </a>
        <a href="admin_dashboard.php" class="btn btn-info">
            <span class="btn-icon">🏪</span>
            إدارة المتاجر
        </a>
        <a href="agents_financials.php" class="btn btn-success">
            <span class="btn-icon">💰</span>
            حسابات المندوبين
        </a>
    </div>
    <a href="logout.php" class="btn btn-logout">
        <span class="btn-icon">🚪</span>
        تسجيل الخروج
    </a>
</div>

<div class="page-header">
    <h2 class="page-title">إدارة المستخدمين</h2>
</div>

<div class="table-wrapper">
    <div class="table-controls">
        <div class="search-box">
            <input type="text" id="searchInput" 
                   placeholder="🔍 ابحث عن مستخدم (الاسم، البريد، الهاتف، الدور...)">
        </div>
        <div class="filter-controls">
            <select class="filter-select" data-column="الدور الحالي">
                <option value="all">جميع الأدوار</option>
                <option value="admin">Admin</option>
                <option value="agent">Agent</option>
                <option value="user">User</option>
                <option value="vendor">Vendor</option>
            </select>
        </div>
    </div>

    <table id="usersTable">
        <thead>
            <tr>
                <th class="sortable">#</th>
                <th class="sortable">اسم المستخدم</th>
                <th class="sortable">البريد الإلكتروني</th>
                <th class="sortable">الهاتف</th>
                <th class="sortable">الدور الحالي</th>
                <th>تغيير الدور</th>
                <th>حذف المستخدم</th>
            </tr>
        </thead>
        <tbody>
            <?php while($user = $res->fetch_assoc()): ?>
            <tr>
                <td><?= $user['id'] ?></td>
                <td><?= htmlspecialchars($user['username']) ?></td>
                <td><?= htmlspecialchars($user['email']) ?></td>
                <td><?= htmlspecialchars($user['phone']) ?></td>
                <td>
                    <span class="badge <?= $user['role'] === 'admin' ? 'badge-danger' : ($user['role'] === 'agent' ? 'badge-info' : 'badge-secondary') ?>">
                        <?= htmlspecialchars($user['role']) ?>
                    </span>
                </td>
                <td>
                    <form method="post" class="form-inline">
                        <input type="hidden" name="user_id" value="<?= $user['id'] ?>">
                        <select name="new_role" class="form-control" style="min-width: 120px;">
                            <?php 
                            $roles = ['admin','agent','user','vendor'];
                            foreach($roles as $role){
                                $selected = ($role == $user['role']) ? 'selected' : '';
                                echo "<option value='$role' $selected>$role</option>";
                            }
                            ?>
                        </select>
                        <button type="submit" name="change_role" class="btn btn-primary">تغيير</button>
                    </form>
                </td>
                <td>
                    <form method="post" onsubmit="return confirm('هل أنت متأكد من حذف هذا المستخدم؟');">
                        <input type="hidden" name="user_id" value="<?= $user['id'] ?>">
                        <button type="submit" name="delete_user" class="btn btn-danger">🗑️ حذف</button>
                    </form>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>

<script src="js/main.js"></script>
</body>
</html>