<?php

ini_set('display_errors', 1);
error_reporting(E_ALL);

include "config.php";

/* حماية الأدمن */
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    die("غير مصرح بالدخول");
}

/* =========================
   إضافة إشعار (عام / حسب الدور / مستخدم)
========================= */
if (isset($_POST['add_notification'])) {

    $target   = $_POST['target'];
    $title    = trim($_POST['title']);
    $message  = trim($_POST['message']);
    $user_id  = !empty($_POST['user_id']) ? intval($_POST['user_id']) : null;

    // توليد group_key موحد لهذه العملية
    $group_key = $target . '_' . time();

    // 🔹 إشعار عام (صف واحد)
    if ($target === 'all') {

        $stmt = $conn->prepare(
            "INSERT INTO notifications (user_id, title, message, group_key)
             VALUES (NULL, ?, ?, ?)"
        );
        $stmt->bind_param("sss", $title, $message, $group_key);
        $stmt->execute();
    }

    // 🔹 إشعار لمستخدم محدد (صف واحد)
    elseif ($target === 'user' && $user_id) {

        $stmt = $conn->prepare(
            "INSERT INTO notifications (user_id, title, message, group_key)
             VALUES (?, ?, ?, ?)"
        );
        $stmt->bind_param("isss", $user_id, $title, $message, $group_key);
        $stmt->execute();
    }

    // 🔹 إشعار حسب الدور (عدة صفوف بنفس group_key)
    elseif (in_array($target, ['admin','agent','vendor','user'])) {

        $users = $conn->prepare(
            "SELECT id FROM users WHERE role = ?"
        );
        $users->bind_param("s", $target);
        $users->execute();
        $res = $users->get_result();

        $insert = $conn->prepare(
            "INSERT INTO notifications (user_id, title, message, group_key)
             VALUES (?, ?, ?, ?)"
        );

        while ($u = $res->fetch_assoc()) {
            $insert->bind_param("isss", $u['id'], $title, $message, $group_key);
            $insert->execute();
        }
    }
}

/* =========================
   تعديل إشعار (تعديل جماعي حسب group_key)
========================= */
if (isset($_POST['edit_notification'])) {

    $group_key = $_POST['group_key'];
    $title     = trim($_POST['title']);
    $message   = trim($_POST['message']);

    $stmt = $conn->prepare(
        "UPDATE notifications
         SET title = ?, message = ?
         WHERE group_key = ?"
    );
    $stmt->bind_param("sss", $title, $message, $group_key);
    $stmt->execute();
}

/* =========================
   حذف إشعار (حذف جماعي)
========================= */
if (isset($_POST['delete_notification'])) {

    $group_key = $_POST['group_key'];

    $stmt = $conn->prepare(
        "DELETE FROM notifications WHERE group_key = ?"
    );
    $stmt->bind_param("s", $group_key);
    $stmt->execute();
}

/* =========================
   جلب الإشعارات (بدون تكرار بصري)
========================= */
$res = $conn->query("
    SELECT 
        n.group_key,
        MAX(n.id) AS id,
        MAX(n.title) AS title,
        MAX(n.message) AS message,
        MAX(n.created_at) AS created_at,
        GROUP_CONCAT(DISTINCT u.username SEPARATOR ', ') AS usernames
    FROM notifications n
    LEFT JOIN users u ON n.user_id = u.id
    GROUP BY n.group_key
    ORDER BY MAX(n.created_at) DESC
    LIMIT 200
");
?>
<!DOCTYPE html>
<html lang="ar">
<head>
<meta charset="UTF-8">
<title>إدارة الإشعارات</title>

<style>
.header {
    background: #343a40;
    color: #fff;
    padding: 10px 15px;
    margin-bottom: 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-radius: 6px;
}

.header a {
    color: #fff;
    text-decoration: none;
    margin-left: 10px;
    padding: 6px 10px;
    border-radius: 4px;
    font-size: 14px;
}

.header a.home {
    background: #007bff;
}

.header a.logout {
    background: #dc3545;
}

.header a:hover {
    opacity: 0.9;
}

body { font-family: Arial; background:#f5f5f5; }
.form-box { background:#fff; padding:15px; border-radius:6px; margin-bottom:20px; }
textarea { width:100%; min-height:120px; }
input, select { width:100%; margin-bottom:10px; padding:6px; }

table { width:100%; border-collapse:collapse; background:#fff; }
th, td { padding:8px; border:1px solid #ddd; vertical-align:top; }
th { background:#eee; }

.btn { padding:6px 10px; cursor:pointer; }
.btn-success { background:#28a745; color:#fff; border:0; }
.btn-info { background:#17a2b8; color:#fff; border:0; }
.btn-danger { background:#dc3545; color:#fff; border:0; }
</style>
</head>

<body>
    <div class="header">
    <div>
        لوحة التحكم
    </div>

    <div>
        <a href="admin_stats.php" class="home">🏠 الرئيسية</a>
        <a href="logout.php" class="logout"
           onclick="return confirm('هل أنت متأكد من تسجيل الخروج؟');">
           🚪 تسجيل الخروج
        </a>
    </div>
</div>


<h2>🔔 إدارة الإشعارات</h2>

<!-- إضافة إشعار -->
<div class="form-box">
<h3>➕ إضافة إشعار</h3>

<form method="post">

<label>إرسال إلى</label>
<select name="target" required>
    <option value="all">📢 عام</option>
    <option value="admin">👑 أدمن</option>
    <option value="agent">🚚 مندوب</option>
    <option value="vendor">🏪 متجر</option>
    <option value="user">👤 مستخدم محدد</option>
</select>

<label>رقم المستخدم (عند مستخدم محدد)</label>
<input type="number" name="user_id" placeholder="User ID">

<label>العنوان</label>
<input type="text" name="title" required>

<label>الرسالة</label>
<textarea name="message" required></textarea>

<button class="btn btn-success" name="add_notification">إضافة</button>
</form>
</div>

<!-- جدول الإشعارات -->
<table>
<thead>
<tr>
<th>#</th>
<th>المستلمون</th>
<th>العنوان</th>
<th>الرسالة</th>
<th>التاريخ</th>
<th>تعديل</th>
<th>حذف</th>
</tr>
</thead>
<tbody>

<?php while ($n = $res->fetch_assoc()): ?>
<tr>
<td><?= $n['id'] ?></td>
<td><?= $n['usernames'] ?: 'عام' ?></td>
<td><?= htmlspecialchars($n['title']) ?></td>
<td><?= nl2br(htmlspecialchars($n['message'])) ?></td>
<td><?= $n['created_at'] ?></td>

<td>
<form method="post">
<input type="hidden" name="group_key" value="<?= $n['group_key'] ?>">
<input type="text" name="title" value="<?= htmlspecialchars($n['title']) ?>">
<textarea name="message"><?= htmlspecialchars($n['message']) ?></textarea>
<button class="btn btn-info" name="edit_notification">حفظ</button>
</form>
</td>

<td>
<form method="post" onsubmit="return confirm('حذف الإشعار بالكامل؟');">
<input type="hidden" name="group_key" value="<?= $n['group_key'] ?>">
<button class="btn btn-danger" name="delete_notification">🗑️</button>
</form>
</td>
</tr>
<?php endwhile; ?>

</tbody>
</table>

</body>
</html>
