<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include __DIR__ . '/../db.php';

/* حماية صلاحيات الأدمن */
if(!isset($_SESSION['role']) || $_SESSION['role'] != 'admin'){
    die("غير مصرح بالدخول");
}

/* ==========================
   تحديث حالة is_active
========================== */
if(isset($_POST['update_status'])) {
    $request_id = intval($_POST['request_id']);
    $new_status = intval($_POST['is_active']);
    $stmt = $conn->prepare("UPDATE market_requests SET is_active = ? WHERE id = ?");
    $stmt->bind_param("ii", $new_status, $request_id);
    $stmt->execute();
    $stmt->close();
}

/* ==========================
   جلب الطلبات مع فلاتر
========================== */
$type_filter = $_GET['type'] ?? '';
$governorate_filter = $_GET['governorate'] ?? '';
$search = $_GET['search'] ?? '';

$sql = "SELECT mr.*, u.username AS user_name
        FROM market_requests mr
        LEFT JOIN users u ON mr.user_id = u.id
        WHERE 1=1";

$params = [];
$types = '';

if($type_filter !== ''){
    $sql .= " AND mr.type = ?";
    $params[] = $type_filter;
    $types .= 's';
}

if($governorate_filter !== ''){
    $sql .= " AND mr.governorate = ?";
    $params[] = $governorate_filter;
    $types .= 's';
}

if($search !== ''){
    $sql .= " AND mr.part_name LIKE ?";
    $params[] = "%$search%";
    $types .= 's';
}

$sql .= " ORDER BY mr.created_at DESC LIMIT 500";

$stmt = $conn->prepare($sql);
if(!empty($params)){
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();
$requests = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();

/* ==========================
   جلب قائمة المحافظات لتصفية الفلاتر
========================== */
$governorates = [];
$g_res = $conn->query("SELECT DISTINCT governorate FROM market_requests");
if($g_res){
    while($g_row = $g_res->fetch_assoc()){
        $governorates[] = $g_row['governorate'];
    }
}

?>

<!DOCTYPE html>
<html lang="ar">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>إدارة الطلبات</title>
<style>
body { font-family: Tahoma, Arial, sans-serif; background:#f4f6f8; padding:20px; color:#333; max-width:1400px; margin:auto; }
.nav-bar { display:flex; justify-content:space-between; align-items:center; margin-bottom:20px; flex-wrap:wrap; }
.nav-links a { margin-right:10px; text-decoration:none; padding:6px 12px; background:#1976d2; color:#fff; border-radius:5px; }
.nav-links a:hover { background:#155fa0; }
.btn-logout { background:#f44336; color:#fff; padding:6px 12px; border-radius:5px; text-decoration:none; }
.table-wrapper { overflow-x:auto; background:#fff; border-radius:6px; padding:10px; }
table { width:100%; border-collapse:collapse; }
th, td { border:1px solid #ddd; padding:6px 8px; text-align:center; font-size:13px; }
th { background:#f0f0f0; font-weight:bold; }
button { padding:4px 10px; border:none; border-radius:5px; background:#1976d2; color:#fff; cursor:pointer; }
button:hover { background:#155fa0; }
select, input { padding:4px; border-radius:4px; }
.filter-form { margin-bottom:15px; background:#fff; padding:12px; border-radius:6px; display:flex; flex-wrap:wrap; gap:10px; align-items:center; }
</style>
</head>
<body>

<div class="nav-bar">
    <div class="nav-links">
        <a href="admin_stats.php">🏠 الرئيسية</a>

    </div>
    <a href="logout.php" class="btn-logout">🚪 تسجيل الخروج</a>
</div>

<h2>📦 إدارة الطلبات</h2>

<!-- ==========================
     فلترة الطلبات
========================== -->
<form method="get" class="filter-form">
    <label>النوع:
        <select name="type">
            <option value="">الكل</option>
            <option value="request" <?= $type_filter=='request'?'selected':'' ?>>طلب</option>
            <option value="offer" <?= $type_filter=='offer'?'selected':'' ?>>عرض</option>
        </select>
    </label>
    <label>المحافظة:
        <select name="governorate">
            <option value="">الكل</option>
            <?php foreach($governorates as $g): ?>
                <option value="<?= htmlspecialchars($g) ?>" <?= $g==$governorate_filter?'selected':'' ?>><?= htmlspecialchars($g) ?></option>
            <?php endforeach; ?>
        </select>
    </label>
    <label>بحث باسم القطعة:
        <input type="text" name="search" value="<?= htmlspecialchars($search) ?>">
    </label>
    <button type="submit">فلترة</button>
</form>

<div class="table-wrapper">
<table>
<thead>
<tr>
<th>رقم الطلب</th>
<th>النوع</th>
<th>اسم القطعة</th>
<th>اسم المستخدم</th>
<th>رقم التواصل</th>
<th>المحافظة</th>
<th>الحالة</th>
<th>تاريخ الإنشاء</th>
<th>تحديث</th>
</tr>
</thead>
<tbody>
<?php foreach($requests as $r): ?>
<tr>
<td><?= $r['id'] ?></td>
<td><?= htmlspecialchars($r['type']) ?></td>
<td><?= htmlspecialchars($r['part_name']) ?></td>
<td><?= htmlspecialchars($r['user_name'] ?? '-') ?></td>
<td><?= htmlspecialchars($r['contact_phone']) ?></td>
<td><?= htmlspecialchars($r['governorate']) ?></td>
<td>
<form method="post" style="margin:0;">
<input type="hidden" name="request_id" value="<?= $r['id'] ?>">
<select name="is_active">
    <option value="0" <?= $r['is_active']==0 ? 'selected':'' ?>>قيد المراجعة</option>
    <option value="1" <?= $r['is_active']==1 ? 'selected':'' ?>>مقبول</option>
    <option value="2" <?= $r['is_active']==2 ? 'selected':'' ?>>مرفوض</option>
    <option value="3" <?= $r['is_active']==3 ? 'selected':'' ?>>محذوف</option>
</select>
</td>
<td><?= $r['created_at'] ?></td>
<td>
<button type="submit" name="update_status">تحديث</button>
</form>
</td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
</div>

</body>
</html>
