<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

// استدعاء اتصال قاعدة البيانات
include "../db.php"; // افترض أن db.php موجود في api/
$conn->set_charset("utf8mb4");

// صلاحيات الأدمن
if(!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin'){
    die("غير مصرح بالدخول");
}

/* رابط ديناميكي للتطبيق بدون control_panel */
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
$host = $_SERVER['HTTP_HOST'];
$scriptFolder = str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'])); // مجلد control_panel
$BASE_URL = $protocol . $host . str_replace('/control_panel','',$scriptFolder) . '/';

/* تغيير الحالة (قيد المراجعة / مفعل) */
if(isset($_POST['change_status'])){
    $product_id = intval($_POST['product_id']);
    $new_status = intval($_POST['new_status']);

    $stmt = $conn->prepare("
        UPDATE user_guest_products 
        SET is_active = ?
        WHERE id = ? AND is_active != 2
    ");
    $stmt->bind_param("ii", $new_status, $product_id);
    $stmt->execute();
}

/* حذف منطقي */
if(isset($_POST['delete_product'])){
    $product_id = intval($_POST['product_id']);

    $stmt = $conn->prepare("
        UPDATE user_guest_products 
        SET is_active = 2
        WHERE id = ?
    ");
    $stmt->bind_param("i", $product_id);
    $stmt->execute();
}

/* جلب المنتجات */
$res = $conn->query("
    SELECT 
        id,
        user_id,
        category,
        name,
        image_url,
        price,
        phone,
        governorate,
        is_active,
        created_at
    FROM user_guest_products
    ORDER BY id DESC
");
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>إدارة منتجات الزوار</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>

<div class="nav-bar">
    <div class="nav-links">
        <a href="admin_stats.php" class="btn btn-home">🏠 الرئيسية</a>
        <a href="manage_users.php" class="btn btn-info">👥 المستخدمين</a>
    </div>
    <a href="logout.php" class="btn btn-logout">🚪 تسجيل الخروج</a>
</div>

<div class="page-header">
    <h2 class="page-title">إدارة منتجات الزوار</h2>
</div>

<div class="table-wrapper">

    <div class="table-controls">
        <input type="text" id="searchInput"
               placeholder="🔍 بحث (الاسم، الفئة، الهاتف، المحافظة)">
    </div>

    <table id="productsTable">
        <thead>
        <tr>
            <th>#</th>
            <th>الفئة</th>
            <th>اسم المنتج</th>
            <th>الصورة</th>
            <th>السعر</th>
            <th>الهاتف</th>
            <th>المحافظة</th>
            <th>الحالة</th>
            <th>الإجراء</th>
            <th>حذف</th>
        </tr>
        </thead>
        <tbody>

        <?php while($p = $res->fetch_assoc()): ?>
        <tr>

            <td><?= $p['id'] ?></td>
            <td><?= htmlspecialchars($p['category']) ?></td>
            <td><?= htmlspecialchars($p['name']) ?></td>

            <!-- صورة المنتج -->
            <td>
                <?php if(!empty($p['image_url'])): 
                    $img = $BASE_URL . ltrim($p['image_url'], '/');
                ?>
                    <a href="<?= htmlspecialchars($img) ?>" target="_blank">
                        <img src="<?= htmlspecialchars($img) ?>"
                             alt="صورة المنتج"
                             style="
                                width:70px;
                                height:70px;
                                object-fit:cover;
                                border-radius:8px;
                                border:1px solid #ddd;
                             ">
                    </a>
                <?php else: ?>
                    <span class="text-muted">لا توجد صورة</span>
                <?php endif; ?>
            </td>

            <td><?= number_format($p['price'], 2) ?></td>
            <td><?= htmlspecialchars($p['phone']) ?></td>
            <td><?= htmlspecialchars($p['governorate']) ?></td>

            <!-- الحالة -->
            <td>
                <?php if($p['is_active'] == 0): ?>
                    <span class="badge badge-warning">قيد المراجعة</span>
                <?php elseif($p['is_active'] == 1): ?>
                    <span class="badge badge-success">مفعل</span>
                <?php else: ?>
                    <span class="badge badge-danger">محذوف</span>
                <?php endif; ?>
            </td>

            <!-- تغيير الحالة -->
            <td>
            <?php if($p['is_active'] != 2): ?>
                <form method="post" class="form-inline">
                    <input type="hidden" name="product_id" value="<?= $p['id'] ?>">

                    <select name="new_status" class="form-control">
                        <option value="0" <?= $p['is_active']==0?'selected':'' ?>>قيد المراجعة</option>
                        <option value="1" <?= $p['is_active']==1?'selected':'' ?>>مفعل</option>
                    </select>

                    <button type="submit"
                            name="change_status"
                            class="btn btn-primary">
                        حفظ
                    </button>
                </form>
            <?php else: ?>
                <span class="text-muted">—</span>
            <?php endif; ?>
            </td>

            <!-- حذف منطقي -->
            <td>
            <?php if($p['is_active'] != 2): ?>
                <form method="post"
                      onsubmit="return confirm('هل أنت متأكد من حذف المنتج؟');">
                    <input type="hidden" name="product_id" value="<?= $p['id'] ?>">
                    <button type="submit"
                            name="delete_product"
                            class="btn btn-danger">
                        🗑️ حذف
                    </button>
                </form>
            <?php else: ?>
                <span class="text-muted">—</span>
            <?php endif; ?>
            </td>

        </tr>
        <?php endwhile; ?>

        </tbody>
    </table>

</div>

<script src="js/main.js"></script>
</body>
</html>
