<?php
session_start();

/* 🔐 حماية صلاحيات الأدمن */
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    die('غير مصرح بالدخول');
}

/* 📁 مسار ملف الإعدادات */
$config_file = __DIR__ . '/../gift_settings.php';
if (!file_exists($config_file)) {
    die('ملف الإعدادات غير موجود');
}

/* تحميل القيم الحالية */
include $config_file;

$success_message = '';
$error_message   = '';

/* حفظ التعديلات */
if (isset($_POST['save_config'])) {
    $store_id               = intval($_POST['store_id']);
    $campaign_id            = intval($_POST['campaign_id']);
    $max_winners            = intval($_POST['max_winners']);
    $max_attempts_per_user  = intval($_POST['max_attempts_per_user']);
    $ribbon_text            = trim($_POST['ribbon_text']);
    $enable_wheel_tab       = isset($_POST['enable_wheel_tab']);

    $offer_end_time = strtotime($_POST['offer_end_time']);
    if ($offer_end_time === false) $error_message = 'تاريخ الانتهاء غير صالح';

    $wheel_prizes_detailed = [];
    if (empty($_POST['prize_label']) || empty($_POST['prize_weight']) || empty($_POST['prize_max'])) {
        $error_message = 'يجب إدخال جائزة واحدة على الأقل';
    } else {
        foreach ($_POST['prize_label'] as $i => $label) {
            $label = trim($label);
            $weight = floatval($_POST['prize_weight'][$i]);
            $max    = intval($_POST['prize_max'][$i]);

            if ($label === '') { $error_message = 'اسم الجائزة لا يمكن أن يكون فارغًا'; break; }
            if ($weight <= 0) { $error_message = 'وزن الجائزة يجب أن يكون أكبر من صفر'; break; }
            if ($max < 0) { $error_message = 'عدد الفائزين لا يمكن أن يكون سالبًا'; break; }

            $wheel_prizes_detailed[] = [
                'label' => $label,
                'weight' => $weight,
                'max_winners' => $max,
            ];
        }
    }

    if (empty($wheel_prizes_detailed)) $error_message = 'لا يمكن حفظ الإعدادات بدون جوائز';

    if (empty($error_message)) {
        $wheel_prizes = array_map(fn($p) => $p['label'], $wheel_prizes_detailed);

        $content  = "<?php\n";
        $content .= "// 🎡 gift_settings.php (تم توليد الملف تلقائيًا)\n\n";
        $content .= "\$store_id = {$store_id};\n";
        $content .= "\$campaign_id = {$campaign_id};\n";
        $content .= "\$max_winners = {$max_winners};\n";
        $content .= "\$offer_end_time = {$offer_end_time};\n";
        $content .= "\$ribbon_text = " . var_export($ribbon_text, true) . ";\n";
        $content .= "\$max_attempts_per_user = {$max_attempts_per_user};\n";
        $content .= "\$wheel_prizes_detailed = " . var_export($wheel_prizes_detailed, true) . ";\n";
        $content .= "\$wheel_prizes = " . var_export($wheel_prizes, true) . ";\n";
        $content .= "\$enable_wheel_tab = " . ($enable_wheel_tab ? 'true' : 'false') . ";\n";

        if (file_put_contents($config_file, $content) === false) $error_message = 'فشل حفظ ملف الإعدادات';
        else $success_message = 'تم حفظ الإعدادات بنجاح';
    }
}
?>
<!DOCTYPE html>
<html lang="ar">
<head>
<meta charset="UTF-8">
<title>إدارة إعدادات العجلة</title>
<link rel="stylesheet" href="css/style.css">
<style>
body { font-family: Tahoma, Arial, sans-serif; background:#f4f6f8; padding:20px; max-width:900px; margin:auto; color:#333; }
.nav-bar { display:flex; justify-content:space-between; margin-bottom:20px; }
.nav-links a { margin-right:10px; text-decoration:none; padding:6px 12px; background:#1976d2; color:#fff; border-radius:5px; }
.nav-links a:hover { background:#155fa0; }
.btn-logout { background:#f44336; color:#fff; padding:6px 12px; border-radius:5px; text-decoration:none; }
h2, h3 { margin-bottom:10px; }
.form-group { margin-bottom:10px; }
label { font-weight:bold; display:block; margin-bottom:4px; }
input, textarea { padding:6px 8px; font-size:13px; border:1px solid #ccc; border-radius:4px; }
input[type="number"], input[type="text"] { width:180px; }
textarea { width:100%; max-width:400px; height:55px; resize:vertical; }
input[type="checkbox"] { transform:scale(0.9); margin-left:5px; }
table { width:auto; border-collapse:collapse; margin-top:10px; background:#fff; }
th, td { border:1px solid #ddd; padding:6px 8px; text-align:center; font-size:12px; }
th { background:#f0f0f0; font-weight:bold; }
table input { padding:4px 6px; font-size:12px; border-radius:3px; }
table input[type="text"] { width:160px; }
table input[type="number"] { width:80px; }
table th:nth-child(1) { background-color: #4caf50; color:#fff; } /* اسم الجائزة */
table th:nth-child(2) { background-color: #ff9800; color:#fff; } /* عدد الفائزين */
table th:nth-child(3) { background-color: #9c27b0; color:#fff; } /* الوزن */

button { padding:8px 20px; font-size:13px; border:none; border-radius:5px; background:#3976d2; color:#fff; cursor:pointer; }
button:hover { background:#155fa0; }
.success { background:#4caf50; color:#fff; padding:8px 10px; border-radius:4px; margin-bottom:10px; }
.error { background:#f44336; color:#fff; padding:8px 10px; border-radius:4px; margin-bottom:10px; }
</style>
</head>
<body>

<div class="nav-bar">
    <div class="nav-links">
        <a href="admin_stats.php">🏠 الرئيسية</a>
        <a href="wheel_winners.php">🎡  قائمة الفائزين</a>
    </div>
    <a href="logout.php" class="btn-logout">🚪 تسجيل الخروج</a>
</div>

<h2>🎡 إعدادات العجلة والجوائز</h2>

<?php if ($success_message): ?><div class="success"><?= $success_message ?></div><?php endif; ?>
<?php if ($error_message): ?><div class="error"><?= $error_message ?></div><?php endif; ?>

<form method="post">

<div class="form-group">
<label>رقم المتجر</label>
<input type="number" name="store_id" value="<?= htmlspecialchars($store_id) ?>" required>
</div>

<div class="form-group">
<label>رقم الحملة</label>
<input type="number" name="campaign_id" value="<?= htmlspecialchars($campaign_id) ?>" required>
</div>

<div class="form-group">
<label>الحد الأقصى للفائزين</label>
<input type="number" name="max_winners" value="<?= htmlspecialchars($max_winners) ?>" required>
</div>

<div class="form-group">
<label>وقت انتهاء العرض</label>
<input type="datetime-local" name="offer_end_time" value="<?= date('Y-m-d\TH:i', $offer_end_time) ?>" required>
</div>

<div class="form-group">
<label>نص الشريط</label>
<textarea name="ribbon_text"><?= htmlspecialchars($ribbon_text) ?></textarea>
</div>

<div class="form-group">
<label>عدد المحاولات لكل مستخدم</label>
<input type="number" name="max_attempts_per_user" value="<?= htmlspecialchars($max_attempts_per_user) ?>" required>
</div>

<label>
<input type="checkbox" name="enable_wheel_tab" <?= $enable_wheel_tab ? 'checked' : '' ?>>
 إظهار تبويب العجلة
</label>

<h3>🎁 الجوائز</h3>
<table>
<tr>
<th>اسم الجائزة</th>
<th>عدد الفائزين</th>
<th>الوزن</th>
</tr>
<?php foreach ($wheel_prizes_detailed as $prize): ?>
<tr>
<td><input type="text" name="prize_label[]" value="<?= htmlspecialchars($prize['label']) ?>"></td>
<td><input type="number" name="prize_max[]" value="<?= htmlspecialchars($prize['max_winners']) ?>"></td>
<td><input type="number" step="0.01" name="prize_weight[]" value="<?= htmlspecialchars($prize['weight']) ?>"></td>
</tr>
<?php endforeach; ?>
</table>

<br>
<button type="submit" name="save_config">💾 حفظ الإعدادات</button>
</form>

</body>
</html>
