<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    die('غير مصرح');
}

$config_file = __DIR__ . '/../get_featured_stores.php';
$content = file_get_contents($config_file);

/* استخراج القيم الحالية */
preg_match('/\$featuredStoreIds\s*=\s*(\[[^\]]*\])\s*;/', $content, $idsMatch);
preg_match('/\$bannerImages\s*=\s*(\[[\s\S]*?\])\s*;/', $content, $bannersMatch);

$featured_ids_text = $idsMatch[1] ?? '[]';
$banners_text = $bannersMatch[1] ?? '[]';

/* مجلد الصور */
$image_folder = realpath(__DIR__ . '/../storePicUploads/add/') . '/';
$ad_images = ['ad1.png', 'ad2.png', 'ad3.png'];

/* رابط ديناميكي للصور حسب السيرفر */
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
$host = $_SERVER['HTTP_HOST'];
$scriptFolder = str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'])); // مجلد control_panel
$BASE_URL = $protocol . $host . str_replace('/control_panel','',$scriptFolder) . '/storePicUploads/add/';

/* حفظ بيانات النصوص */
if (isset($_POST['save'])) {

    $new_ids = trim($_POST['featured_ids']);
    $new_banners = trim($_POST['banners']);

    $content = preg_replace(
        '/\$featuredStoreIds\s*=\s*\[[^\]]*\]\s*;/s',
        '$featuredStoreIds = ' . $new_ids . ';',
        $content
    );

    $content = preg_replace(
        '/\$bannerImages\s*=\s*[\s\S]*?\s*;/s',
        '$bannerImages = ' . $new_banners . ';',
        $content
    );

    file_put_contents($config_file, $content);
    $saved = true;
}

/* حفظ الصور المرفوعة */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['ads'])) {
    foreach ($_FILES['ads']['name'] as $i => $name) {
        if ($_FILES['ads']['error'][$i] === UPLOAD_ERR_OK) {
            $tmp_name = $_FILES['ads']['tmp_name'][$i];
            $target_file = $image_folder . $ad_images[$i];

            // حذف القديم (إذا موجود)
            if (file_exists($target_file)) {
                unlink($target_file);
            }

            // نقل الجديد
            move_uploaded_file($tmp_name, $target_file);
        }
    }
    $image_saved = true;
}
?>
<!DOCTYPE html>
<html lang="ar">
<head>
<meta charset="UTF-8">
<title>تعديل المتاجر المميزة</title>
<link rel="stylesheet" href="css/style.css">
<style>
body { font-family: sans-serif; padding: 20px; background: #f9f9f9; }
.nav-bar { display:flex; justify-content:space-between; margin-bottom:20px; }
.nav-links a { margin-right:10px; text-decoration:none; padding:5px 10px; background:#2196F3; color:#fff; border-radius:5px; }
.nav-links a:hover { background:#1976D2; }
.btn-logout { background:#f44336; color:#fff; padding:5px 10px; border-radius:5px; text-decoration:none; }
.page-header h2 { margin-bottom:20px; }
textarea { width:100%; padding:0.5rem; border:1px solid #ccc; border-radius:5px; }
button { padding:10px 20px; cursor:pointer; border:none; border-radius:5px; background:#4caf50; color:#fff; }
button:hover { background:#45a049; }
.success { background:#d4edda; color:#155724; padding:10px; border-radius:5px; margin-bottom:1rem; }
.form-group { margin-bottom:1rem; }
label { font-weight:bold; display:block; margin-bottom:0.3rem; }
.ad-images { display:flex; gap:20px; margin-top:1rem; }
.ad-images div { text-align:center; }
.ad-images img { width:150px; height:150px; border:1px solid #ccc; border-radius:5px; object-fit:cover; display:block; margin-bottom:0.5rem; }
</style>
</head>
<body>

<div class="nav-bar">
    <div class="nav-links">
        <a href="admin_stats.php">🏠 الرئيسية</a>
        <a href="admin_dashboard.php">🏪 إدارة المتاجر</a>
        <a href="manage_users.php">👥 إدارة المستخدمين</a>
        <a href="manage_guest_products.php">📦 منتجات الزوار</a>
    </div>
    <a href="logout.php" class="btn-logout">🚪 تسجيل الخروج</a>
</div>

<div class="page-header">
    <h2>تعديل المتاجر المميزة</h2>
</div>

<?php if(!empty($saved)): ?>
<div class="success">✅ تم حفظ البيانات بنجاح!</div>
<?php endif; ?>

<?php if(!empty($image_saved)): ?>
<div class="success">✅ تم تحديث الصور بنجاح!</div>
<?php endif; ?>

<form method="post" enctype="multipart/form-data">
    <div class="form-group">
        <label>أرقام المتاجر</label>
        <textarea name="featured_ids" rows="5"><?= htmlspecialchars($featured_ids_text) ?></textarea>
    </div>

    <div class="form-group">
        <label>روابط البانرات</label>
        <textarea name="banners" rows="5"><?= htmlspecialchars($banners_text) ?></textarea>
    </div>

    <button type="submit" name="save">💾 حفظ التعديلات</button>

    <h3 style="margin-top:2rem;">🖼 صور الإعلانات الحالية</h3>
    <div class="ad-images">
        <?php foreach ($ad_images as $i => $img): ?>
            <div>
                <img src="<?= $BASE_URL . $img ?>?<?= time() ?>" alt="<?= $img ?>">
                <input type="file" name="ads[]">
                <div><?= $img ?></div>
            </div>
        <?php endforeach; ?>
    </div>

    <button type="submit" style="margin-top:1rem;">💾 حفظ الصور</button>
</form>

</body>
</html>
