<?php
session_start();
include "config.php";

$error = '';
$need_agent_id = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = trim($_POST['password'] ?? '');
    $agent_input = trim($_POST['agent_id'] ?? '');

    $stmt = $conn->prepare("SELECT id, username, password, role FROM users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        $error = "اسم المستخدم أو كلمة المرور غير صحيحة";
    } else {
        $user = $result->fetch_assoc();

        if ($password === $user['password']) {
            $_SESSION['user_id']  = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['role']     = $user['role'];

            if ($user['role'] === 'admin') {
                header("Location: admin_stats.php");
                exit;
            }

            if ($user['role'] === 'agent') {
                if (empty($agent_input)) {
                    $need_agent_id = true;
                } else {
                    $_SESSION['agent_id'] = $agent_input;
                    header("Location: agent_dashboard.php");
                    exit;
                }
            }

            $error = "غير مسموح بالدخول";
        } else {
            $error = "اسم المستخدم أو كلمة المرور غير صحيحة";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تسجيل الدخول - لوحة التحكم</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <div class="login-wrapper">
        <div class="login-container">
            <h2>تسجيل الدخول</h2>
            
            <?php if ($error): ?>
                <div class="alert alert-error">
                    <span>⚠️</span>
                    <span><?= htmlspecialchars($error) ?></span>
                </div>
            <?php endif; ?>
            
            <form method="post">
                <div class="form-group">
                    <input type="text" name="username" class="form-control" 
                           placeholder="اسم المستخدم" required autocomplete="username">
                </div>
                
                <div class="form-group">
                    <input type="password" name="password" class="form-control" 
                           placeholder="كلمة المرور" required autocomplete="current-password">
                </div>
                
                <?php if ($need_agent_id): ?>
                    <div class="form-group">
                        <input type="text" name="agent_id" class="form-control" 
                               placeholder="أدخل Agent ID الخاص بك" required>
                    </div>
                <?php endif; ?>
                
                <button type="submit" class="btn btn-primary">
                    <span class="btn-icon">🔐</span>
                    دخول
                </button>
            </form>
        </div>
    </div>
    <script src="js/main.js"></script>
</body>
</html>