<?php
session_start();
include "config.php";

if(!isset($_SESSION['role']) || $_SESSION['role'] !== 'agent'){
    die("غير مصرح بالدخول");
}

$agent_id = $_SESSION['agent_id'];

$q1 = $conn->prepare("SELECT COALESCE(SUM(amount),0) FROM agent_collections WHERE agent_id=?");
$q1->bind_param("s", $agent_id);
$q1->execute();
$q1->bind_result($total_collected);
$q1->fetch();
$q1->close();

$q2 = $conn->prepare("SELECT COALESCE(SUM(amount),0) FROM agent_settlements WHERE agent_id=?");
$q2->bind_param("s", $agent_id);
$q2->execute();
$q2->bind_result($total_settled);
$q2->fetch();
$q2->close();

$balance = $total_collected - $total_settled;

$stmt = $conn->prepare("
    SELECT ac.*, s.name AS store_name 
    FROM agent_collections ac
    JOIN stores s ON s.id = ac.store_id
    WHERE ac.agent_id=?
    ORDER BY ac.collected_at DESC
");
$stmt->bind_param("s", $agent_id);
$stmt->execute();
$result = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ملخص المندوب المالي</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>

<div class="nav-bar">
    <div class="nav-links">
        <a href="agent_dashboard.php" class="btn btn-home">
            <span class="btn-icon">🏠</span>
            الرئيسية
        </a>
    </div>
    <a href="logout.php" class="btn btn-logout">
        <span class="btn-icon">🚪</span>
        تسجيل الخروج
    </a>
</div>

<div class="page-header">
    <h2 class="page-title">الملخص المالي</h2>
</div>

<div class="stats-container">
    <div class="stat-card success">
        <div class="stat-icon">💰</div>
        <div class="stat-label">مجموع القبوضات</div>
        <div class="stat-value"><?= number_format($total_collected, 2) ?> $</div>
    </div>
    <div class="stat-card warning">
        <div class="stat-icon">📤</div>
        <div class="stat-label">مجموع المسلّم</div>
        <div class="stat-value"><?= number_format($total_settled, 2) ?> $</div>
    </div>
    <div class="stat-card <?= $balance > 0 ? 'danger' : 'info' ?>">
        <div class="stat-icon">📊</div>
        <div class="stat-label">الرصيد المتبقي</div>
        <div class="stat-value"><?= number_format($balance, 2) ?> $</div>
    </div>
</div>

<h3 style="text-align: center; margin: 2rem 0 1rem;">سجل القبوضات</h3>
<div class="table-wrapper">
    <table>
        <thead>
            <tr>
                <th class="sortable">المتجر</th>
                <th class="sortable">المبلغ</th>
                <th class="sortable">المستوى</th>
                <th class="sortable">المدة</th>
                <th class="sortable">التاريخ</th>
            </tr>
        </thead>
        <tbody>
            <?php while($row = $result->fetch_assoc()): ?>
            <tr>
                <td><?= htmlspecialchars($row['store_name']) ?></td>
                <td><strong><?= number_format($row['amount'], 2) ?> $</strong></td>
                <td><?= htmlspecialchars($row['tier']) ?></td>
                <td><?= htmlspecialchars($row['subscription_type']) ?></td>
                <td><?= htmlspecialchars($row['collected_at']) ?></td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>

<script src="js/main.js"></script>
</body>
</html>