<?php
include "config.php";

if($_SESSION['role'] !== 'admin'){
    die("غير مصرح بالدخول");
}

$agent_id = $_GET['agent_id'] ?? '';

if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $amount = floatval($_POST['amount']);
    $notes = trim($_POST['notes']);

    $stmt = $conn->prepare("
        INSERT INTO agent_settlements (agent_id, amount, admin_id, notes)
        VALUES (?, ?, ?, ?)
    ");
    $stmt->bind_param("sdis", $agent_id, $amount, $_SESSION['user_id'], $notes);
    $stmt->execute();

    header("Location: agent_financials.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تسجيل تسليم</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>

<div class="nav-bar">
    <div class="nav-links">
        <a href="agent_financials.php" class="btn btn-back">
            <span class="btn-icon">⬅</span>
            رجوع
        </a>
    </div>
    <a href="logout.php" class="btn btn-logout">
        <span class="btn-icon">🚪</span>
        تسجيل الخروج
    </a>
</div>

<div class="form-container">
    <h2>تسجيل تسليم المندوب: <?= htmlspecialchars($agent_id) ?></h2>
    
    <form method="post">
        <div class="form-group">
            <label for="amount">المبلغ</label>
            <input type="number" step="0.01" name="amount" id="amount" 
                   class="form-control" placeholder="أدخل المبلغ" required>
        </div>
        
        <div class="form-group">
            <label for="notes">ملاحظات</label>
            <textarea name="notes" id="notes" class="form-control" 
                      placeholder="أدخل أي ملاحظات (اختياري)"></textarea>
        </div>
        
        <button type="submit" class="btn btn-primary" style="width: 100%;">
            <span class="btn-icon">💾</span>
            حفظ
        </button>
    </form>
</div>

<script src="js/main.js"></script>
</body>
</html>