<?php
include "config.php";

/* السماح للمندوب فقط */
if(!isset($_SESSION['role']) || $_SESSION['role'] !== 'agent'){
    die("غير مصرح بالدخول");
}

/* تغيير الدور */
if(isset($_POST['change_role'])){
    $user_id = intval($_POST['user_id']);
    $new_role = $_POST['new_role'];

    // منع تغيير دور الأدمن
    $check = $conn->prepare("SELECT role FROM users WHERE id=?");
    $check->bind_param("i", $user_id);
    $check->execute();
    $result = $check->get_result()->fetch_assoc();

    if($result && $result['role'] === 'admin'){
        die("لا يمكن تعديل حساب أدمن");
    }

    $stmt = $conn->prepare("UPDATE users SET role=? WHERE id=?");
    $stmt->bind_param("si", $new_role, $user_id);
    $stmt->execute();
}

/* حذف مستخدم */
if(isset($_POST['delete_user'])){
    $user_id = intval($_POST['user_id']);

    // منع حذف الأدمن
    $check = $conn->prepare("SELECT role FROM users WHERE id=?");
    $check->bind_param("i", $user_id);
    $check->execute();
    $result = $check->get_result()->fetch_assoc();

    if($result && $result['role'] === 'admin'){
        die("لا يمكن حذف حساب أدمن");
    }

    $stmt = $conn->prepare("DELETE FROM users WHERE id=?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
}

/* جلب آخر 20 مستخدم فقط */
$res = $conn->query("
    SELECT id, username, email, phone, role 
    FROM users 
    ORDER BY id DESC 
    LIMIT 20
");
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة آخر المستخدمين</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>

<!-- شريط علوي مبسط -->
<div class="nav-bar">
    <div class="nav-links">
        <a href="agent_dashboard.php" class="btn btn-home">
            <span class="btn-icon">🏠</span>
            الرئيسية
        </a>
    </div>
    <a href="logout.php" class="btn btn-logout">
        <span class="btn-icon">🚪</span>
        تسجيل الخروج
    </a>
</div>

<div class="page-header">
    <h2 class="page-title">آخر 20 مستخدم</h2>
</div>

<div class="table-wrapper">
    <table id="usersTable">
        <thead>
            <tr>
                <th>#</th>
                <th>اسم المستخدم</th>
                <th>البريد الإلكتروني</th>
                <th>الهاتف</th>
                <th>الدور</th>
                <th>تغيير الدور</th>
                <th>حذف</th>
            </tr>
        </thead>
        <tbody>
        <?php while($user = $res->fetch_assoc()): ?>
            <tr>
                <td><?= $user['id'] ?></td>
                <td><?= htmlspecialchars($user['username']) ?></td>
                <td><?= htmlspecialchars($user['email']) ?></td>
                <td><?= htmlspecialchars($user['phone']) ?></td>
                <td>
                    <span class="badge <?= $user['role'] === 'agent' ? 'badge-info' : 'badge-secondary' ?>">
                        <?= htmlspecialchars($user['role']) ?>
                    </span>
                </td>
                <td>
                    <?php if($user['role'] !== 'admin'): ?>
                    <form method="post" class="form-inline">
                        <input type="hidden" name="user_id" value="<?= $user['id'] ?>">
                        <select name="new_role" class="form-control">
                            <?php
                            $roles = ['agent','user','vendor'];
                            foreach($roles as $role){
                                $selected = ($role == $user['role']) ? 'selected' : '';
                                echo "<option value='$role' $selected>$role</option>";
                            }
                            ?>
                        </select>
                        <button type="submit" name="change_role" class="btn btn-primary">
                            تغيير
                        </button>
                    </form>
                    <?php else: ?>
                        <span style="color:#999">غير مسموح</span>
                    <?php endif; ?>
                </td>
                <td>
                    <?php if($user['role'] !== 'admin'): ?>
                    <form method="post" onsubmit="return confirm('هل أنت متأكد من الحذف؟');">
                        <input type="hidden" name="user_id" value="<?= $user['id'] ?>">
                        <button type="submit" name="delete_user" class="btn btn-danger">
                            🗑️
                        </button>
                    </form>
                    <?php else: ?>
                        <span style="color:#999">—</span>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endwhile; ?>
        </tbody>
    </table>
</div>

</body>
</html>
